#!perl -wW
package CyberArmy::WWW::Splash;

use strict;

use CyberArmy::Template;

$CyberArmy::WWW::Splash::VERSION = '0.1';

sub handler {
	my $r = CyberArmy::WWW::Request->instance();
	return -1 unless $r->is_initial_req();

	my $splash = $r->dir_config('dinah_splash')
		or return -1;	## if no slash template defined
						## decline the request

	my $cookies = $r->getParams({ from => 'cookies' });
	if ($cookies->{'splash'} eq $splash) { return -1 }
	else {
		$r->err_headers_out->add( 
			'Set-Cookie' => 'splash='.$splash.'; path=/');
		$r->multipleChoices([ ],$splash,{uri => $r->uri});
	}

	return 0;
}
