#!perl -wW
package CyberArmy::WWW::Recruiting;

use strict;
use CyberArmy::User;
use CyberArmy::Template;
use CyberArmy::Recruiting;

$CyberArmy::WWW::Search::VERSION = '0.1';


#the usual handler stuff
sub handler {
	my $r = shift;
	my (undef,$node) = split(/\//,$r->path_info);
	if (not $node) { &search }

    else { return -1 }
}




sub search {
	my $r = CyberArmy::WWW::Request->instance();
	$r->redirectTo($r->uri .'/') unless ($r->uri =~ m{/$});
    my $params = $r->method ne 'POST' ? $r->getParams({escapehtml => 1, multi => { skills => 1 }}) :
				$r->getParams({from => 'posted', escapehtml => 1, multi => { multusers => 1, skills => 1 }});


	if (!$params->{'action'}) {
			$r->printTemplate('recruiting/search.tmpl',{
			skills => CyberArmy::SkillsDB::listSkills(),
			levels => CyberArmy::SkillsDB::getskilllevels(),
			});

	} elsif ($params->{'action'} eq "slctlevels") {
			$r->errorTemplate(412,'recruiting/error_skills.tmpl') unless $params->{'skills'};

			$r->printTemplate('recruiting/search.tmpl',{
			skills => CyberArmy::SkillsDB::listSkills(),
			slctskills => $params->{'skills'},
			levels => CyberArmy::SkillsDB::getskilllevels(),
			action => $params->{'action'}
			});

	} elsif ($params->{'action'} eq "result") {
			my (@skills,@levels,@only);
			#defines the basic vars
			$params->{'limit'} ||= 25;
			$params->{'page'} ||= 1;
			$params->{'offset'} = ($params->{'page'} - 1) * $params->{'limit'};


			foreach my $s ( @{$params->{'skills'}} )  {
				$params->{'levels'}->{$s} = $params->{'level_'.$s};
				$params->{'only'}->{$s} = $params->{'only_'.$s};
			}


			#search for the members and store them in @result
			my @result = CyberArmy::Recruiting::searchSkill((
					skills => $params->{'skills'},
					levels => $params->{'levels'},
					only => $params->{'only'},
					orderby => $params->{'orderby'},
					limit => $params->{'limit'},
					offset => $params->{'offset'}
					));

			#stores the result numbers in understandable vars
			my $totalresult = $result[0][-1];
  
			#determines the number of pages which have to be used
			my $pages=0;
			if ($params->{'limit'} ne "all") { 
				$pages= $totalresult / $params->{'limit'};
				$pages= int $pages + 1 unless ($pages == int $pages);
			}

			#print the search result
			$r->printTemplate('recruiting/search.tmpl',{
				action => $params->{'action'},
				skills => CyberArmy::SkillsDB::listSkills(),
				levels => CyberArmy::SkillsDB::getskilllevels(),
				#the found users
				result => @result,
				#the total number and the results of each skill
				resultnum => $totalresult,
				#the selected skills and levels to show them again
				selectedskills => $params->{'skills'},
				selectedlevels => $params->{'levels'},
				only => $params->{'only'},
				orderby => $params->{'orderby'},
				#the number of pages, the current page and the selected limit
				pages => {
					num => $pages,
					current => $params->{'page'},
					limit => $params->{'limit'}
				},
				#the boxes next to the nickname and all features
				#apart from the E-Mail function only are displayed 
				#to ppl who are logged in 
				loggedin => CyberArmy::WWW::Request::User->instance ? 1 : 0
				});

		

		} elsif ($params->{'action'} eq "multcms") {
			#send multiple cMS to the found members
			$r->errorTemplate(412,'recruiting/error_multuser.tmpl') unless ($params->{'multusers'});
			$r->printTemplate('recruiting/multusers.tmpl', {
				type => "cms",
				users => $params->{'multusers'}
			});
		}


}
1;
