#!perl -wW
package CyberArmy::WWW::Groupware;

#
# Groupware Manager
#

## Apache module, managing logins

use strict;

use CyberArmy::User;
use CyberArmy::Brigades;
use CyberArmy::Groupware;
use CyberArmy::WWW::Request;

$CyberArmy::WWW::Groupware::VERSION = '0.1';

sub handler {
	my $r = CyberArmy::WWW::Request->instance( shift );
	my $params = $r->getParams();
	my $user = CyberArmy::WWW::Request::User->instance();
	
	my $vars = {};

	$vars->{'groups'} = CyberArmy::Groupware->get();
	$vars->{'group'} = CyberArmy::Groupware
		->get($params->{'group'}) if $params->{'group'};
	return (404) if ($params->{'group'} && !$vars->{'group'});
		
	$vars->{'brigade'} = CyberArmy::Brigades->new
		($vars->{'group'}->{'brigade'}) if $vars->{'group'};
	$vars->{'user'} = $user;
	$vars->{'xcyberarmy'} = ($user && ($user->IsInBrigade(1) > 3)) ? 1:0;
		
	$params->{'action'} ||= 'view';
	
	if ($params->{'action'} eq 'view') {
		$r->printTemplate('groupware/view.tmpl',$vars);
	} elsif ($params->{'action'} eq 'edit') {
		return (403) unless $user;

		if ($vars->{'group'}) {
			return (403) unless
				($user->IsInGroup('x'.$vars->{'group'}->{'brigade'}));
		} else {
			return (403) unless ($vars->{'xcyberarmy'});
		}
	
		if ($r->method eq 'POST') {
			my $posted = $r->getParams({from=>'posted'});
			($posted->{'id'} and $posted->{'name'}) or $r->exit(412);
			
			if ($params->{'group'}) {
				return (403) unless 
					($posted->{'id'} eq $params->{'group'});
			} else { return (403) if $vars->{'group'} }

			if ($posted->{'action'} eq 'delete') {
				return (403) unless $vars->{'xcyberarmy'};
				$r->redirectTo(
					CyberArmy::Groupware->del($posted->{'id'}) ? $r->uri
						: $r->uri. '?action=edit&group=' .$posted->{'id'}
				);
			} else {
				## some fields cannot be changed unless you have ultimate access
				if ($vars->{'group'} && !$vars->{'xcyberarmy'}) {
					foreach (qw(id priority hitpoints brigade 
						deprecated_by depends_on add_title  
							add_title_abrv add_badge add_role)) {
							$posted->{$_} = $vars->{'group'}->{$_};
					}
				}
				
				CyberArmy::Groupware->set($posted) or return (500);
				$r->redirectTo($r->uri. '?action=edit&group=' .$posted->{'id'});
			}
		} else {
			$r->printTemplate('groupware/edit.tmpl',$vars);
		}
	} elsif ($params->{'action'} eq 'admin') {
		return (403) unless $user;
		if ($vars->{'group'}) {
			return (403) unless
				($user->IsInGroup('x'.$vars->{'group'}->{'brigade'})
					|| $user->IsInGroup($vars->{'group'}->{'master'}));
		} else { return (412) }
		
		if ($r->method eq 'POST') {
			my $posted = $r->getParams({from=>'posted',multi=>{group=>1}});
			$posted->{'action'} || return (412);
			if ($posted->{'action'} eq 'add') {
				foreach(split/[\n\r]+/,$posted->{'add_user'}) {
					my $victim = CyberArmy::User->new(nickname => $_) or next;
					$victim->Update(addtogroup => $params->{'group'});
					$victim->Log( 
						type => 'modified', logby => $user->nickname,
						logbycaID => $user->caID, 
						msg => 'Added to group '.$params->{'group'}
					);
				}
			} elsif ($posted->{'action'} eq 'delete') {
				foreach (@{$posted->{'group'}}) {
					my $victim = CyberArmy::User->new(nickname => $_) or next;
					$victim->Update(delfromgroup => $params->{'group'});
					$victim->Log( 
						type => 'modified', logby => $user->nickname,
						logbycaID => $user->caID, 
						msg => 'Removed from group '.$params->{'group'}
					);
				}
				
			} else { return (412) }
			$r->redirectTo($r->uri. '?' .$r->args);
		} else {
			$vars->{'users'} = CyberArmy::Groupware->getUsers($params->{'group'});
			$r->printTemplate('groupware/admin.tmpl',$vars);
		}
	}
	
	return 0;
}

1;
