#!/usr/bin/perl -wW
package CyberArmy::WWW::Command;

use strict;

$CyberArmy::WWW::VERSION = '0.1';

use CyberArmy::Database;

our $template;

sub handler {
    my $r = CyberArmy::WWW::Request->instance();

    my (undef, $node,$subnode) = split(/\//, $r->path_info);
	$template = {}; $template->{'node'} = $node;

	my $params = $r->getParams({'escapehtml' => 1});
    if (not $node) {
        if ($params->{'node'}) {
            if ($params->{'node'} eq 'main') {
                $r->redirectTo('/command/');
            } else {
                $r->redirectTo('/command/' . $params->{'node'} . '/');
            }
        } else {
			$r->redirectTo($r->uri . '/') unless ($r->uri =~ /\/$/);
		
			chomp ($template->{'w'} = `w`);
			chomp ($template->{'uname'} = `uname -mnrs`);
		
		# get total users with security flag (necessary because should be rare but requires attention)
		my $cmd = $CyberArmy::Utils::Database::dbh->prepare(q~
		select count(nickname) from users where `securityflag`='1'
		~);
		
		$cmd->execute();
		
		my @sth = $cmd->fetchrow_array;
		
		$template->{'flagged'} = $sth[0];
		
			$r->printTemplate('command/command.tmpl', $template);
		}
    }
    elsif ($node eq 'logs') { &showLogs; }
    elsif ($node eq 'skills') { &showSkills; }
    elsif ($node eq 'userip') { &showUserIP; }
    elsif ($node eq 'stats') { &showStats; }
    elsif ($node eq 'joinstats') { &showJoinStats; }
    elsif ($node eq 'user') { &showUser; }
    elsif ($node eq 'flagged') { &showFlagged; }
    else { return 404 }
}

sub showLogs {
	my $r = CyberArmy::WWW::Request->instance();
	my $params = $r->getParams({'escapehtml' => 1});

    my $db = CyberArmy::Database->instance();
    my $cmd;
    
    my $limit;
		if (!$params->{'limit'}) {
			$limit=50;
		} else {
			$limit = $params->{'limit'};
		}    
    if ($params->{'by'} && ($template->{'value'} = $params->{'value'})) {

		foreach ( qw(nickname logby msg date) ) {
			if ($params->{'by'} eq $_) {
				$template->{'by'} = $_; last;
			}
		} $template->{'by'} or return 412;

        $limit = $params->{'limit'} 
            if (defined $params->{'limit'} && $params->{'limit'} =~ /^\d+$/);
        my $where ='`'.$params->{'by'} . '` ' .
             ($params->{'value'} =~ /%/ ? 'LIKE ?' : '= ?');
		if($params->{'by'} eq 'nickname')
		{
			$where = ($params->{'value'} =~ /%/ ? $where : " log_users.caid = (SELECT users.caid FROM users WHERE users.nickname = ? ) ");
		}
        $cmd = $db->prepare('SELECT nickname,type,msg,logby,date ' .
            'FROM log_users WHERE ' . $where .
             ' ORDER BY date DESC ' .
             ($limit != 0 ? 'LIMIT ' . $limit : ''));
        $cmd->execute($params->{'value'});
    } else {
        $cmd = $db->prepare(
            'SELECT nickname,type,msg,logby,date ' .
            'FROM log_users ORDER BY date DESC LIMIT ' . $limit);
        $cmd->execute();
    }
    
    $template->{'limit'} = $limit;
    $template->{'logs'} = $cmd->fetchall_arrayref({});
    $r->printTemplate('command/logs.tmpl', $template);
	
	return 0;
}

sub showSkills {
	my $r = CyberArmy::WWW::Request->instance();
	my $params = $r->getParams({'escapehtml' => 1});

    if ($r->method eq 'POST') {
        $r->checkReferer('/command/skills/') or return 412;
        my $posted = $r->getParams({'from' => 'posted', 'escapehtml' => 1});

        if ($posted->{'action'}) {

            if ($posted->{'action'} eq 'addskill') {
                ($posted->{'skill'} && $posted->{'reference'}) or return 412;
                CyberArmy::SkillsDB->addSkill(
					$posted->{'skill'}, $posted->{'reference'});

            } elsif ($posted->{'action'} eq 'delskill') {
                $posted->{'skill'} or return 412;
                CyberArmy::SkillsDB->delSkill($posted->{'skill'});

            } elsif ($posted->{'action'} eq 'addlevel') { 
                $posted->{'level'} or return 412;
                CyberArmy::SkillsDB->addskilllevel($posted->{'level'});

            } elsif ($posted->{'action'} eq 'dellevel') {
                $posted->{'level'} or return 412;
                CyberArmy::SkillsDB->delskilllevel($posted->{'level'});
            } else { return 404 }

        } else { return 404 }
    }

    $template->{'skills'} = CyberArmy::SkillsDB->listSkills;
    $template->{'levels'} = CyberArmy::SkillsDB->getskilllevels;
    $r->printTemplate('command/skills.tmpl', $template);
	
	return 0;
}

sub showUserIP {
	my $r = CyberArmy::WWW::Request->instance();
	my $params = $r->getParams({'escapehtml' => 1});

    if ($params->{'ip'}) {
        $params->{'ip'} =~ /^(?:(?:\d{1,3}|%)\.??){1,4}$/ or return 412;

        my @nicknames;
		my $db = CyberArmy::Database->instance();
		
        my $cmd = $db->prepare('SELECT nickname,msg FROM log_users ' . 
            'WHERE msg LIKE ?');
        $cmd->execute('joined from ' . $params->{'ip'});

        while (my $row = $cmd->fetchrow_hashref()) {
            push(@nicknames, $row->{'nickname'});
        }

        $cmd = $db->prepare('SELECT nickname,session_ip FROM users ' . 
            'WHERE session_ip LIKE ?');
        $cmd->execute($params->{'ip'});

        while (my $row = $cmd->fetchrow_hashref()) {
            push(@nicknames, $row->{'nickname'});
        }

        $template->{'ip'} = $params->{'ip'};
        $template->{'nicknames'} = \@nicknames;
    }

    $r->printTemplate('command/userip.tmpl', $template);
	
	return 0;
}

sub showStats {
	my $db = CyberArmy::Database->instance();
	
	my $temp;
	
    my $cmd = $db->prepare('SELECT COUNT(*) FROM users');
    $cmd->execute();
    # Decrease by one because of system account.
	$template->{'totalUsers'} = --($temp = $cmd->fetchrow_array());

    $cmd = $db->prepare('SELECT COUNT(*) FROM users WHERE session_ltime IS NULL');
    $cmd->execute();
    %{$template->{'neverLoggedIn'}} = ('d' => $temp = $cmd->fetchrow_array(),
        'p' => sprintf('%.2f', $temp / $template->{'totalUsers'} * 100));

    $cmd = $db->prepare('SELECT COUNT(*) FROM users WHERE brigade IS NOT NULL');
    $cmd->execute();
    %{$template->{'inBrigade'}} = ('d' => $temp = $cmd->fetchrow_array(),
        'p' => sprintf('%.2f', $temp / $template->{'totalUsers'} * 100));

    foreach (qw(1 2 7 30)) {
        $cmd = $db->prepare('SELECT COUNT(*) FROM users WHERE ' .
            'FROM_UNIXTIME(session_ltime) > ADDDATE(NOW(), INTERVAL - ? DAY)');
        $cmd->execute($_);
        my %temp = ('day' => $_, 'd' => $temp = $cmd->fetchrow_array(),
            'p' => sprintf('%.2f', $temp / $template->{'totalUsers'} * 100));
        push (@{$template->{'lastLogins'}}, \%temp);
    }

    my @ranks = qw(cinc vicecinc marshal general kernel lieutenantkernel
                   major captain lieutenant secondlieutenant trooper);

    $cmd = $db->prepare('SELECT id,add_badge FROM groupware WHERE id IN (' . 
        join(',', map {$db->quote($_)} @ranks) . ')');
    $cmd->execute();
    my $badges = $cmd->fetchall_hashref('id');

    my $last = 0; my $alast =0;
		my $query;
    foreach (@ranks) {
        $cmd = $db->prepare('SELECT COUNT(*) FROM user_group WHERE group_id = ?');
        $cmd->execute($_);
				$query = $db->prepare('SELECT COUNT(*) FROM users INNER JOIN user_group ON ' . 
					'(users.caid = user_group.caid AND user_group.group_id = ?) WHERE ' . 
					'FROM_UNIXTIME(users.session_ltime)>ADDDATE(NOW(), INTERVAL-30 DAY)'); # i got myself a nice query here
				#which is used to get the active members of each group in the database (active troopers etc.)
				$query->execute($_); 
				my $active;
        my %temp = ('name' => $_, 'badge' => $badges->{$_}->{'add_badge'},
            'd' => $temp = $cmd->fetchrow_array() - $last,
            'p' => sprintf('%.2f', $temp / $template->{'totalUsers'} * 100),
						'a' => $active = $query->fetchrow_array() - $alast);
        $last += $temp;
				$alast += $active;
        push (@{$template->{'ranks'}}, \%temp);
    }
    
    
    $cmd = $db->prepare('SELECT COUNT(*) AS joins, MonthName(joined_on) AS month, 
    				Year(joined_on) AS year FROM users GROUP BY Year, Month ORDER BY joined_on DESC ');
    $cmd->execute();
	my $joins = $cmd->fetchall_arrayref({});
    $template->{'joins'} = $joins;
	my $r = CyberArmy::WWW::Request->instance();
    $r->printTemplate('command/stats.tmpl', $template);
	
	return 0;
}


sub showJoinStats {
	my $db = CyberArmy::Database->instance();
	
	my $temp;
	#Get number of joins per month    
    my $cmd = $db->prepare('SELECT COUNT(*) AS joins, MonthName(joined_on) AS month, 
    				Year(joined_on) AS year FROM users GROUP BY Year, Month ORDER BY joined_on DESC ');
    $cmd->execute();
	my $joins = $cmd->fetchall_arrayref({});
    $template->{'joins'} = $joins;
    
    #Get results of 'reasons for joining' poll (done on signup)
    my $reasons = $CyberArmy::Utils::Database::dbh->prepare(
					"SELECT * From join_reasons order by reason asc"
				);
	$reasons->execute();
	my $reasonList = $reasons->fetchall_arrayref({});
	my $countTotalVotes= $CyberArmy::Utils::Database::dbh->prepare(
			"SELECT COUNT(*) FROM join_reason_votes ");
	$countTotalVotes->execute() or return undef;
	my $totalVotesCount = $countTotalVotes->fetchrow_array();
	my $countTotalAbstains= $CyberArmy::Utils::Database::dbh->prepare(
			"SELECT COUNT(*) FROM join_reason_votes WHERE reason_id=0 ");
	$countTotalAbstains->execute() or return undef;
	my $abstainVotesCount = $countTotalAbstains->fetchrow_array();
	foreach my $reason (@$reasonList){		
		my $countVotes= $CyberArmy::Utils::Database::dbh->prepare(
			"SELECT COUNT(*) FROM join_reason_votes ".
			"WHERE reason_id = ?"
		); $countVotes->execute($reason->{id}) or return undef;
		$reason->{votes} = sprintf('%.2f', ($countVotes->fetchrow_array() / $totalVotesCount) * 100) ;
	}
    $template->{'reasons'} = $reasonList;
    $template->{'voteCount'} = $totalVotesCount;
    $template->{'abstainVotesCount'} = $abstainVotesCount;
    
    #Get free text comments
    my $comments = $CyberArmy::Utils::Database::dbh->prepare(
					"SELECT comments From join_reason_votes order by rdate desc"
				);
	$comments->execute();
	my $commentList = $comments->fetchall_arrayref({});
    $template->{'comments'} = $commentList;
	
	my $r = CyberArmy::WWW::Request->instance();
    $r->printTemplate('command/join_stats.tmpl', $template);
	
	return 0;
}

sub showUser {
	my $r = CyberArmy::WWW::Request->instance();
	my $user = CyberArmy::WWW::Request::User->instance();

    if ($r->method eq 'POST') {
        my $posted = $r->getParams({'from' => 'posted', 'escapehtml' => 1});
        ($posted->{'action'} && $posted->{'user'}) or return 412;

		my $params = $r->getParams({'escapehtml' => 1});
        if ((not my $victim = new CyberArmy::User('nickname' => $params->{'user'})) &&
	   (not my $post_victim = new CyberArmy::User('nickname' => $posted->{'user'})))
	{
             $template->{'error'} = 'No such user...';
        } else {
			my $db = CyberArmy::Database->instance();
			my $cmd;
            ############################
            # Update
            ############################
            if ($posted->{'action'} eq 'update') {
                $posted->{'value'} or return 412;

                $user->IsInGroup($r->dir_config->get('ACL_EDITUSER')) 
					or return 403;

                if ($victim->Update($posted->{'value'} 
						=> $posted->{$posted->{'value'}})) {
                    $victim->Log(
						'type' => 'modified',
						'logby' => $user->nickname,
                        'logbycaID' => $user->caID, 
						'msg' => 'Updated field '.$posted->{'value'});
                } else {
                    $template->{'error'} = 'Updating ' . $posted->{'update'} 
					. ' for ' . $victim->nickname . ' Failed';
                }
            }
            ############################
            # AddToGroup
            ############################
            elsif ($posted->{'action'} eq 'addtogroup') {
                $posted->{'group'} or return 412;

                my $group = $db->selectrow_hashref('SELECT brigade,master FROM groupware WHERE id = ?',
					undef,$posted->{'group'});
                if (!$group->{'brigade'}) {
                    ($user->IsInGroup('vicecinc')||$user->CheckGroupList($group->{'master'})) or return 403;
                } else {
                    ($user->IsInGroup('x'.$group)||$user->CheckGroupList($group->{'master'})) or return 403;
                }

                if ($victim->Update('addtogroup' => $posted->{'group'})) {
                    $victim->Log( 'type' => 'modified', 'logby' => $user->nickname,
                        'logbycaID' => $user->caID, 'msg' => 'Added to group '.$posted->{'group'});
                } else {
                    $template->{'error'} = 'Adding ' . $victim->nickname . ' to group ' . $posted->{'group'} . ' failed';
                }
            }
            ############################
            # DeleteFromGroup
            ############################
            elsif ($posted->{'action'} eq 'delfromgroup') {
                $posted->{'group'} or return 412;

                my $group = $db->selectrow_hashref('SELECT brigade,master FROM groupware WHERE id = ?',
					undef,$posted->{'group'});
                
                if (!$group) {
                    ($user->IsInGroup('vicecinc')||$user->CheckGroupList($group->{master})) or return 403;
                } else {
                    ($user->IsInGroup('x'.$group)||$user->CheckGroupList($group->{master})) or return 403;
                }

                if ($victim->Update('delfromgroup' => $posted->{'group'})) {
                    $victim->Log(
						'type' => 'modified',
						'logby' => $user->nickname ,
                        'logbycaID' => $user->caID,
						'msg' => 'Removed from group ' . $posted->{'group'});
                } else {
                    $template->{'error'} = 'Removing ' . $victim->nickname 
						. ' from group ' . $posted->{'group'} . ' failed';
                }
            }
            ############################
            # Ban
            ############################
            elsif ($posted->{'action'} eq 'ban') {
                ($posted->{'value'} && $posted->{'value'} >= 1 
						&& $posted->{'reason'}) or return 412;
						
				my $acl = $r->dir_config->get('ACL_EDITUSER');

                if ($victim->IsBanned) {
                    $template->{'error'} = 'Already banned...';
                } elsif (($user->caID eq $victim->caID)
					or ($victim->IsInGroup($acl) && !$user->IsInGroup($acl))) {
                    $template->{'error'} = 'Oops, cannot modifiy';
                } else {
                    my $bantime; 
					if (!$posted->{'unit'} or $posted->{'unit'} eq 'days') {
                        $bantime = 60 * 60 * 24 * $posted->{'value'};
                    } elsif ($posted->{'unit'} eq 'months') {
                        $bantime = 60 * 60 * 24 * 30 * $posted->{'value'};
                    } elsif ($posted->{'unit'} eq 'years') {
                        $bantime = 60 * 60 * 24 * 30 * 13 * $posted->{'value'};
                    }

                    if ($victim->Update('ban' => $bantime)) {
                        $bantime = $victim->bantime;
                        $victim->Log(
							'type' => 'banned',
							'logby' => $user->nickname ,
                            'logbycaID' => $user->caID,
							'msg' => 'Till '.(gmtime($bantime)).
							' ('.$posted->{'reason'}.')' );

                        if ($posted->{'notice'}) {
                            CyberArmy::Template->instance
				                ->process('command/user/ban_email.tmpl',
					               {'vShowname' => $victim->showname, 'bantime' => gmtime($bantime),
					                'rank' => join(' ', @{($user->getAttributes('title'))->{'title'}}),
					                'showname' => $user->showname, 'notice' => $posted->{'notice'}}, \my $body
                            );

                            CyberArmy::Mail::Send(
                                from => $r->dir_config('MAIL_FROM'),
				                to => [$victim->prvemail, $victim->showname],
				                body => $body,
				                subject => 'Ban Notice (' . $victim->nickname . ')'
				            );
							}
					} else {
						$template->{'error'} = 'Banning ' . $victim->nickname . ' till ' . gmtime($bantime) . ' failed';
					}
                }
            }
            ############################
            # Unban
            ############################
            elsif ($posted->{'action'} eq 'Unban') {
                if (not $victim->IsBanned) {
                    $template->{'error'} = 'Not banned...';
                } else {
                    if ($victim->Update('ban' => undef)) {
                        $victim->Log(
							'type' => 'unbanned',
							'logby' => $user->nickname ,
                            'logbycaID' => $user->caID);
                    } else {
                        $template->{'error'} = 'Unbanning ' .
							$victim->nickname . ' failed';
                    }
                }
            }
            ############################
            # ResetEmail
            ############################
            elsif ($posted->{'action'} eq 'resetemail') {
				$posted->{'newemail'} or return 412;
                $user->IsInGroup(my $acl = $r->dir_config->get('ACL_EDITMAIL'))
					or return 403;

                if ($posted->{'newemail'} ne $victim->prvemail) {
					my $acl = $r->dir_config->get('ACL_EDITMAIL');
                    if ($victim->IsInGroup($acl) && !$user->IsInGroup($acl)) {
                        $template->{'error'} = 'Oops, cannot modifiy ' 
						. $victim->showname;
                    } else {
                        if ($victim->Update(prvemail => $posted->{'newemail'})) {
                            $victim->Log( 
							type => 'modified',
							logby => $user->nickname,
							logbycaID => $user->caID,
							msg => 'Updated field prvemail');
                        } else {
                            $template->{'error'} = 'Failed!';
                        }
                    }
                } else {
                    $template->{'error'} = 'Failed!';
                }
            }
	   ############################
	   # Forced Reset of Password
	   ############################
           elsif ($posted->{'action'} eq 'reset_pass') {
                # We're reseting someones password and sending them another email...

                my $new_password = CyberArmy::Utils::RandomAlphaNum(8);

                $post_victim->Update( passwd => $new_password );

                CyberArmy::Template->instance->process(
                      'bootcamp/forced_reset.tmpl', {
                       user => $post_victim, password => $new_password,
                       server => $r->getServerLink()
                       },\my $body
                );

                CyberArmy::Mail::Send(
                        from => $r->dir_config('MAIL_FROM'),
                        to => $post_victim->prvemail,  body => $body,
                        subject  =>  'Welcome to CyberArmy (Password Reset)',
                );

                $post_victim->Log( 'type' => 'note', 'logby' => $user->nickname,
                        'logbycaID' => $user->caID, 'msg' => 'Resent Users Password ');

		$template->{'error'} = "User's password reset & emailed successfully...";
           }
		   ############################
		   # Add Note
		   ############################
           elsif ($posted->{'action'} eq 'add_note') {
                $post_victim->Log( 'type' => 'note', 'logby' => $user->nickname,
                        'logbycaID' => $user->caID, 'msg' => $posted->{'log'});

				$template->{'error'} = "Note added successfully...";
           }
           

        }
    }

    my (undef, undef, $node) = split(/\//, $r->path_info);
    if (not $node or $template->{'error'}) { 
		$r->printTemplate('command/user/user.tmpl', $template) }
    elsif ($node eq 'view') { &showUserView }
    elsif ($node eq 'edit') { &showUserEdit }
    elsif ($node eq 'groups') { &showUserGroups }
    elsif ($node eq 'email') { &showUserEmail }
    elsif ($node eq 'ban') { &showUserBan }
    else { return 404 }

	return 0;
}

sub showFlagged {
	my ($sth, @flaggedusers);
	my $r = CyberArmy::WWW::Request->instance();
	my $cmd = $CyberArmy::Utils::Database::dbh->prepare(q~
	select nickname from `users` where `securityflag`='1'
	~);
	
	$cmd->execute();
	
	while($sth = $cmd->fetchrow_hashref) {
		push(@flaggedusers, $sth->{nickname});
	}
	$template->{'flagged'} = \@flaggedusers;
	
	$r->printTemplate('command/flagged.tmpl', $template);
}
	
sub showUserView {
	my $r = CyberArmy::WWW::Request->instance();
	my $params = $r->getParams({'escapehtml' => 1});
	my $user = CyberArmy::WWW::Request::User->instance();

    ($params->{'by'} && $params->{'value'}) or return 412;

    if (my $victim = new CyberArmy::User($params->{'by'} => $params->{'value'},
        'select' => 'nickname,showname,prvemail,retired,bantime,session_ip')) {

        $template->{'nickname'} = $victim->nickname;
        $template->{'showname'} = $victim->showname;
        $template->{'prvemail'} = $victim->prvemail;
        $template->{'rank'} = join(' ', @{($victim->getAttributes('title'))->{'title'}});
        if ($victim->session_ltime) {
            $template->{'seen'} = gmtime($victim->session_ltime);
            $template->{'session_ip'} = $victim->session_ip;
        }
        if ($victim->IsBanned) {
            $template->{'banned'} = gmtime($victim->bantime);
        }
        if ($victim->IsSecurityFlagged) {
        		$template->{'flagged'} = "Yes";
        } 
        if ($user->IsInGroup('marshal')) {
            $template->{'editEmail'} = 1;
        }
        if ($user->IsInGroup('vicecinc')) {
            $template->{'edit'} = 1;
        }
    }

    $r->printTemplate('command/user/view.tmpl', $template);
	
	return 0;
}

our @userSelect = qw(
    caID nickname showname passwd pubemail prvemail
    challenge_number brigade brigade_pos away
    bantime retired session_id session_time session_ip
    session_mode session_ltime session_timeout
    publicplan signature securityflag);

sub showUserEdit {
	my $r = CyberArmy::WWW::Request->instance();
	my $params = $r->getParams({'escapehtml' => 1});
	my $user = CyberArmy::WWW::Request::User->instance();
	
    $user->IsInGroup('vicecinc') or return 403;

    $params->{'user'} or return 412;

    if (my $victim = CyberArmy::User->new(
			nickname => $params->{'user'}, 
			select => join(',',@userSelect))
		) {
        $template->{'nickname'} = $victim->nickname;
        $template->{'showname'} = $victim->showname;
        $template->{'rank'} = join(' ', 
			@{($victim->getAttributes('title'))->{'title'}});
        foreach (@userSelect) {
            my %temp = ('name' => $_, 'input' => $victim->$_);
            push (@{$template->{'select'}}, \%temp);
        }
    }

    $r->printTemplate('command/user/edit.tmpl', $template);
	
	return 0;
}

sub showUserGroups {
	my $r = CyberArmy::WWW::Request->instance();
	my $params = $r->getParams({'escapehtml' => 1});
	my $user = CyberArmy::WWW::Request::User->instance();

    $params->{'user'} or return 412;

    if (my $victim = CyberArmy::User->new('nickname' => $params->{'user'},
			'select' => join(',',@userSelect))) {
        $template->{'nickname'} = $victim->nickname;
        $template->{'showname'} = $victim->showname;
        $template->{'rank'} = join(' ', 
			@{($victim->getAttributes('title'))->{'title'}});

        my $cmd = CyberArmy::Database->instance()
            ->prepare('SELECT * FROM groupware');
        $cmd->execute();
        my $group = $cmd->fetchall_hashref('id');

        foreach (sort { $group->{$a}->{'name'} 
				cmp $group->{$b}->{'name'} } keys %{$group}) {

            if (not $group->{$_}->{'brigade'}) {
                next unless ($user->IsInGroup(
					$r->dir_config->get('ACL_EDITUSER'))||$user->CheckGroupList($group->{$_}->{'master'}));
            } else {
                next unless ($user->IsInGroup('x'.$group->{$_}->{'brigade'})||$user->CheckGroupList($group->{$_}->{'master'}));
            }

            my $already = $victim->IsInGroup($_);
            next if ($already && $already != 0E0);
            my %temp = (
				name => $group->{$_}->{'name'}, 
				id => $group->{$_}->{'id'});
            push (@{$template->{'groups'}}, \%temp);
        }

        foreach (sort { $group->{$a}->{'name'} 
			cmp $group->{$b}->{'name'} } keys %{$victim->groups()}) {
            my %temp = ('name' => $group->{$_}->{'name'}, 
				'id' => $group->{$_}->{id},
				'can_remove' => ($user->IsInGroup('x'.$group->{$_}->{'brigade'})||$user->CheckGroupList($group->{$_}->{'master'})));
            push (@{$template->{'victimGroups'}}, \%temp);
        }
    }

    $r->printTemplate('command/user/groups.tmpl', $template);
	
	return 0;
}

sub showUserEmail {
	my $r = CyberArmy::WWW::Request->instance();
	my $params = $r->getParams({'escapehtml' => 1});
	my $user = CyberArmy::WWW::Request::User->instance();

    $user->IsInGroup('marshal') or return 403;

    $params->{'user'} or return 412;

    if (my $victim = CyberArmy::User->new('nickname' => $params->{'user'},
			'select' => join(',',@userSelect))) {
        $template->{'nickname'} = $victim->nickname;
        $template->{'showname'} = $victim->showname;
        $template->{'rank'} = join(' ', 
			@{($victim->getAttributes('title'))->{'title'}});
        $template->{'prvemail'} = $victim->prvemail;
    }

    $r->printTemplate('command/user/email.tmpl', $template);
	
	return 0;
}

sub showUserBan {
	my $r = CyberArmy::WWW::Request->instance();
	my $params = $r->getParams({'escapehtml' => 1});

    $params->{'user'} or return 412;

    if (my $victim = CyberArmy::User->new('nickname' => $params->{'user'},
			'select' => join(',',@userSelect))) {
        $template->{'nickname'} = $victim->nickname;
        $template->{'showname'} = $victim->showname;
        $template->{'rank'} = join(' ', 
			@{($victim->getAttributes('title'))->{'title'}});
        if ($victim->IsBanned) {
            my $ban = $victim->History('events' => 'banned' , 'limit' => 1);
            %{$template->{'ban'}} = (
				'logby' => $ban->[0]->{'logby'},
				'date' => $ban->[0]->{'date'},
				'msg' => $ban->[0]->{'msg'});
        }
    }

    $r->printTemplate('command/user/ban.tmpl', $template);
	
	return 0;
}

1;
