#!perl -wW
package CyberArmy::WWW::Captcha;

#
# Banners API
#

use strict;
use GD ();

$CyberArmy::WWW::Captcha::VERSION = '0.1';

use CyberArmy::Utils;
use CyberArmy::Database;

sub handler {
	my $r = CyberArmy::WWW::Request->instance();
	$r->checkReferer() or return 412;
	
	if ($r->path_info() =~ /(\d+)\.png$/) {
		my $captcha = CyberArmy::WWW::Captcha->new({ id => $1})
			or return 404;
		
		my $im = new GD::Image(36,16);
		my $white = $im->colorAllocate(255,255,255);
		$im->transparent($white);
		$im->string(
			GD::gdLargeFont,2,2,$captcha->{'string'},
			$im->colorAllocate($r->dir_config->get('COLOR'))
		);

		my $png = $im->png();
		$r->header_out('Content-Length' => length($png) );
		$r->send_http_header('image/png');

		$r->print( $png ) unless $r->method eq 'HEAD';

	} else { return 412 }
	
	return 0;
}

sub new {
	my $class = shift;
	my $self = shift;
	my $db = CyberArmy::Database->instance();

	unless ( exists($self->{'id'}) or exists($self->{'string'}) ) {
		## if no keys exist, we issue out a new captcha
		$self->{'string'} = CyberArmy::Utils::RandomAlphaNum(4);
		disambiguate($self->{'string'});
		$self->{'id'} = $db->do(
			'INSERT INTO captcha (string, gen_date) '.
			'VALUES (?,NOW())',undef,$self->{'string'}
		) ? $db->{'mysql_insertid'} : undef
	} elsif (exists($self->{'string'})) {
		disambiguate($self->{'string'});
	}

	my $key = $self->{'id'} ? 'id' : 'string';
	return undef unless defined $self->{$key};

	$self = $db->selectrow_hashref(
		'SELECT * FROM captcha WHERE '.$key.' = ?'
			,undef,$self->{$key}) or return undef;

	bless($self, $class);
}

sub drop {
	CyberArmy::Database->instance()->do(
		'DELETE FROM captcha WHERE id = ?',undef,$_[1]->{'id'}
	);
}

sub disambiguate {
	$_[0] = uc($_[0]);
	$_[0] =~ tr/01/OL/;
}

