package CyberArmy::WWW::Banner;

#
# Banner handler
#

## handles banners redirections

use strict;

$CyberArmy::WWW::Banner::VERSION = '0.6';

use CyberArmy::Banner;
use CyberArmy::WWW::Request;

sub handler {
	my $r = CyberArmy::WWW::Request->instance( shift );
	my $params =  $r->getParams();

	my $adserver = $r->dir_config('dinah_adserver');
	
	if ($params->{'node'}) {
		# show kept for legacy modules
		if ($params->{'node'} eq 'show') {

			if ( my $banner = $params->{'id'} ? 
					CyberArmy::Banner->new({id => $params->{'id'}})
						: CyberArmy::Banner->new()) {
				$r->register_cleanup(sub { $banner->setViewed() });

				$r->printTemplate('banner/show.tmpl',{
					adserver => $adserver,
					banner => $banner,
				});	

			} else { return 500 }
	
		} elsif ($params->{'node'} eq 'image' && $params->{'id'}) {
			if (my $banner = new CyberArmy::Banner({id => $params->{'id'}})) {
				$r->register_cleanup(sub { $banner->setViewed() });
				$r->redirectTo($banner->{'image'});
			} else { return 500 }
		
		} elsif ($params->{'node'} eq 'go' && $params->{'id'}) {
			if (my $banner = new CyberArmy::Banner({id => $params->{'id'}})) {
				$r->register_cleanup(sub { $banner->setClicked() });
				$r->redirectTo($banner->{'url'});			
			} else { return 404 }

		} else { 
			$r->redirectTo($adserver.'?node=show');
		}
	} else {
		$r->redirectTo($adserver.'?node=show');
	}

	return 0;	
}


1;
