#!/usr/bin/perl -W
package CyberArmy::Utils;

#
# This module is used internally to provide common
# subroutines used by other modules of this bundle
#

$CyberArmy::Utils::VERSION = '0.4_9';

use strict;
our @AlphaNum = ('a'..'z','A'..'Z','0'..'9');

sub GetKey {
	my ($tags,$keys) = (@_);
	$keys ||= ['caID','nickname','session_id','prvemail','irc_nickname'];
	my $key; foreach ( @{$keys} ) {	if ( $tags->{$_} ) { $key = $_; last; } } 
	return $key ? { name => $key , value => $tags->{$key} } : undef
}

sub RandomAlphaNum {
	my $rndm; srand();
 	$rndm .= $AlphaNum[int(rand($#AlphaNum + 1))] for (1 .. $_[0]);
	return $rndm;
}

sub getTimeInterval {
	## inspired by Time::Duration
	## Sean M. Burke <sburke@cpan.org>

	my ($remainder,$current,@interval) = (abs $_[0]);

	## Years
	push @interval,[int($remainder / (365 * 24 * 60 * 60)),'year'];
	$remainder -= $interval[0]->[0] * (365 * 24 * 60 * 60);

	## Months
	push @interval,[int($remainder / (30 * 24 * 60 * 60)),'month'];
	$remainder -= $interval[1]->[0] * (30 * 24 * 60 * 60);

	## Weeks
	push @interval,[int($remainder / (7 * 24 * 60 * 60)),'week'];
	$remainder -= $interval[2]->[0] * (7 * 24 * 60 * 60);

	## Days
	push @interval,[int($remainder / (24 * 60 * 60)),'day'];
	$remainder -= $interval[3]->[0] * (24 * 60 * 60);

	## Hours
	push @interval,[int($remainder / (60 * 60)),'hour'];
	$remainder -= $interval[4]->[0] * (60 * 60);

	## Minutes
	push @interval,[int($remainder / 60),'minute'];
	$remainder -= $interval[5]->[0] * 60;

	## Seconds
	push @interval,[int($remainder),'second'];

	return @interval;
}

sub trimHtmlEncoded {	## chawmp
	my ($str, $len, $span) = @_;
	my $newstr = '';
	$len -= 3;
	if ($str =~ /^(([^&]|&.+?;){$len})./) { # too long
		$newstr .= '<span title="' . $str. '">' if ($span);
		$newstr .= $1 . '...';
		$newstr .= '</span>' if ($span);
		return $newstr;
	}
	return $str;
}

# checks a showname is valid, and trims extra spaces out of it
# returns the nicified showname, or undef if it is unacceptable
sub niceShowName {
	my $show = shift;

	return undef unless $show and ($show =~ /^[a-zA-Z0-9 ]+$/);
	$show =~ s/^ +//;
	$show =~ s/ +$//;
	$show =~ s/ +/ /g;
	return undef unless (length($show) < 25);
	return undef unless ($show =~ /^\w/ && $show =~ /\w$/);

	return $show;
}

# converts showname to nickname
sub nickFromShowName {
	my $show = lc(shift);
	$show =~ s/ //g;
	return $show;
}

package CyberArmy::Utils::Database;

use DBI;
use strict;
use CyberArmy;

#
# Just a module to provide a single way to call
# DBI for the sake of persistant connection via
# Apache::DBI
#

our $dbh;

sub init_connect { $dbh = &Connect; }

sub Connect {
	return (DBI->connect(
		$CyberArmy::Config{'DINAH_DSN'},'','')
	or die);
}

&init_connect unless $ENV{'MOD_PERL'};

END { $dbh->disconnect if ($dbh); }

1;
