#!perl -wW
package CyberArmy::User::Messages;

use CyberArmy::User;
use CyberArmy::Database;
use base qw(CyberArmy::User);

$__PACKAGE__::VERSION = '0.5';

sub CyberArmy::User::getMessages {
	bless shift,__PACKAGE__;
}

sub MsgCount {
	my ($self,$folder) = @_;
	my $unstickyCount =  CyberArmy::Database->instance()->selectrow_arrayref(
		'SELECT COUNT(mid) FROM cMS WHERE caID = ? AND folder = ?',
	undef,$self->caID,($folder||'inbox'))->[0];
	my $stickyCount =  CyberArmy::Database->instance()->selectrow_arrayref(
			'SELECT COUNT(mid) FROM cMS WHERE caID = ? AND sticky = 1 AND folder = ?',
	undef,$self->caID,($folder||'inbox'))->[0];
	
	## We need to also add # of stickies to account for these being repeated at the start
	
	return ($unstickyCount + $stickyCount);
}

sub ViewMsgList {
    my ($self,$sticky,@args) = @_;
	my $limit = '';

	my $list;
	my $db = CyberArmy::Database->instance();
	
	if (ref $args[0] eq 'ARRAY') {
		foreach (@{$args[0]}) { /^\d+$/ or return undef }
		my $get = $db->prepare('
			SELECT mid,rdate,sender_name,sender_rank,tostring,subject,body,viewed,direction,replied,forwarded,sticky,UNIX_TIMESTAMP(rdate) AS rdate_ut FROM cMS
			WHERE (caID = ? AND '.($sticky ? 'sticky = 1 AND ' : '').
			'mid IN ('.join(',',@{$args[0]}).')) ORDER BY rdate'
		); $get->execute($self->caID) or return undef;
		
		$list = $get->fetchall_arrayref({});
		$get->finish;
	} else {
		my ($box,$limit,$elimit,$slimit) = ('inbox','');

		if ($args[0]) {
			$box = $args[0];
			if ($elimit = $args[1]) {
				$slimit = $args[2] || 0;
				$limit = 'LIMIT '.$slimit.','.$elimit;
			}
		}
		my $unread = 0;
		my $sth;

		if($box eq 'unread'){
			$box = '%';
			$unread = 1;
			$sth = $db->prepare('
				SELECT mid,sender_name,sender_rank,tostring,subject,rdate,viewed,direction,replied,forwarded,sticky
				FROM cMS WHERE caID = ? AND '.($unread ? 'viewed = \'n\'  ' : '').''.($sticky ? 'AND sticky = 1 ' : '').
				'ORDER BY rdate DESC '.$limit
			);$sth->execute($self->caID) or return undef;
		} else{

			$sth = $db->prepare('
				SELECT mid,sender_name,sender_rank,tostring,subject,rdate,viewed,direction,replied,forwarded,sticky
				FROM cMS WHERE caID = ? AND '.($unread ? 'viewed = \'n\' AND ' : '').''.($sticky ? 'sticky = 1 AND ' : '').
				'folder = ? ORDER BY rdate DESC '.$limit
			); $sth->execute($self->caID,$box) or return undef;
		}
		$list = $sth->fetchall_arrayref({}); $sth->finish; 
	}
	
	return $list;
}

sub ViewMsg {
	my ($self,$mid) = @_;
	return (
		CyberArmy::Database->instance()->selectrow_hashref(q~
			SELECT rdate,sender_name,sender_rank,tostring,subject,body,viewed,direction
			FROM cMS WHERE (mid = ? AND caID = ?)~,
		undef,$mid,$self->caID) || undef
	)
}

sub SetMsgAsRead {
	my ($self,$mid,$viewed) = @_;	
		
	$viewed = (!$viewed || $viewed eq 'y') ? 'y' : 'n';

	(ref $mid eq 'ARRAY') || ($mid = [$mid]);
	foreach (@$mid) { /^\d+$/ or return undef }

	CyberArmy::Database->instance()->do('
		UPDATE cMS SET viewed = ?
		WHERE (caID = ? AND	mid IN ('.join(',',@$mid).'))',
	undef,$viewed,$self->caID);
}

sub CheckForUnreadMsg {
	my $num = CyberArmy::Database->instance()
		->selectrow_arrayref(q~
			SELECT COUNT(*) FROM cMS 
			WHERE (caID = ? AND viewed = 'n')~,
	undef,$_[0]->caID) or return undef;
	return $num->[0];
}

sub DeleteMsg {
	my ($self,$mid) = @_;
		
	(ref $mid eq 'ARRAY') || ($mid = [$mid]);
	foreach (@$mid) { /^\d+$/ or return undef }
	CyberArmy::Database->instance()->do('
		DELETE FROM cMS WHERE (caID = ? AND
		mid IN ('.join(',',@$mid).'))',
	undef,$self->caID);

}

sub SetMsgAsSticky {
	my ($self,$mid,$sticky) = @_;	
		
	$sticky = (!$sticky || $sticky eq 'y') ? '1' : '0';

	(ref $mid eq 'ARRAY') || ($mid = [$mid]);
	foreach (@$mid) { /^\d+$/ or return undef }

	CyberArmy::Database->instance()->do('
		UPDATE cMS SET sticky = ?
		WHERE (caID = ? AND	mid IN ('.join(',',@$mid).'))',
	undef,$sticky,$self->caID);
}

sub NumStickies {
    my ($self,@args) = @_;
	
	if (ref $args[0] eq 'ARRAY') {
		foreach (@{$args[0]}) { /^\d+$/ or return undef }
		return CyberArmy::Database->instance()->selectrow_arrayref(
						'SELECT COUNT(mid) FROM cMS WHERE caID = ? AND sticky=1 AND mid IN ('.join(',',@{$args[0]}).'))',
				undef,$self->caID)->[0];
	} else {
		my ($box) = ('inbox');
		
		if ($args[0]) {		
			$box = $args[0];				
		}		
		return CyberArmy::Database->instance()->selectrow_arrayref(
				'SELECT COUNT(mid) FROM cMS WHERE caID = ? AND sticky=1 AND folder = ?',
				undef,$self->caID,($folder||'inbox'))->[0];
	}
}

#Folder related functions

sub GetFolders {
	my ($self,$empty,$id) = @_;
	my $db = CyberArmy::Database->instance();
	if($empty==0){ #Gets any customised folders the user has created
		my $get = $db->prepare('
			SELECT * FROM cMS_folders
			WHERE caID = ? ORDER BY name'
		);  $get->execute($self->caID) or return undef;
		my $folders = $get->fetchall_arrayref({});
		$get->finish; 
		return $folders;
	}
	elsif($empty==2){#Gets the name of a specific folder id
		my $get = $db->prepare('
			SELECT name FROM cMS_folders
			WHERE caID = ? AND fid = ?'
		);  $get->execute($self->caID,$id) or return undef;
		my $folders = $get->fetchrow_arrayref;
		$get->finish; 
 		if(scalar(@$folders) > 0){
			return $folders->[0];
		}
		else{
			return undef;
		}
	}
	else{ #Gets all empty folders (only empty folders can be deleted)
		my $get = $db->prepare('
			SELECT * from cMS_folders WHERE caID = ? AND cMS_folders.fid NOT IN (SELECT distinct cMS.folder FROM cMS
			WHERE caID = ?) ORDER BY cMS_folders.name'
		);  $get->execute($self->caID,$self->caID) or return undef;
		my $folders = $get->fetchall_arrayref({});
		$get->finish; 
		return $folders;
	}
}

sub CreateFolder { 
	#Add new folder, providing name is unique for this user
	shift;
	my $db = CyberArmy::Database->instance();
	my $exists = $db->selectrow_arrayref(
		'SELECT COUNT(*) FROM cMS_folders WHERE (name = ? AND caID = ?)',
	undef,@_)->[0];
	if($exists==0){
		$db->do(
			'REPLACE INTO cMS_folders (name,description,caID) VALUES (?,"",?)'
		,undef,@_);
	}
}

sub MoveMessage {
	#Move message to different folder
	my ($self,$mid,$viewed) = @_;	
		
	$folder = (!$folder || $folder eq 'inbox') ? 'inbox' : $folder;

	(ref $mid eq 'ARRAY') || ($mid = [$mid]);
	foreach (@$mid) { /^\d+$/ or return undef }

	CyberArmy::Database->instance()->do('
		UPDATE cMS SET folder = ?
		WHERE (caID = ? AND	mid IN ('.join(',',@$mid).'))',
	undef,$viewed,$self->caID);
}

sub DeleteFolder {
	#Delete folder, if empty
	my ($self,$fid) = @_;
		
	CyberArmy::Database->instance()->do('
		DELETE FROM cMS_folders WHERE (caID = ? AND
		fid = ? AND cMS_folders.fid NOT IN (SELECT distinct cMS.folder FROM cMS
			WHERE caID = ?))',
	undef,$self->caID, $fid,$self->caID);

}

sub RenameFolder { 
	my ($self,$fid,$newname) = @_;
	my $db = CyberArmy::Database->instance();
	my $exists = $db->selectrow_arrayref(
		'SELECT COUNT(*) FROM cMS_folders WHERE (fid = ? AND caID = ?)',
	undef,$fid,$self->caID)->[0];
	if($exists>0){
		my $exists2 = $db->selectrow_arrayref(
				'SELECT COUNT(*) FROM cMS_folders WHERE (name = ? AND caID = ? AND fid!= ?)',
			undef,$newname,$self->caID,$fid)->[0];
		if($exists2==0){
			$db->do(
				'UPDATE cMS_folders SET name = ? WHERE fid = ?'
			,undef,$newname,$fid);
		}
	}
}

1;
