#!perl -wW
package CyberArmy::Template::user;

$CyberArmy::Template::user::VERSION = '0.1';

use Template::Plugin;
use base qw( Template::Plugin );

use CyberArmy::User;
use CyberArmy::WWW::Request;


sub init {
	my $self = shift;
	$self->{'_DYNAMIC'} = 1;
	return $self;
}

sub getInfo {
	my $r = CyberArmy::WWW::Request->instance;
	my %info = ();

	if (my $user = CyberArmy::WWW::Request::User->instance) {
		my $getAttr = $user->getAttributes('title_abrv','badge');
		$info{'attributes'} = $getAttr->{'title_abrv'};
		$info{'badges'} =$getAttr->{'badge'};
		$info{'showname'} = $user->showname;
		$info{'nickname'} = $user->nickname;
		$info{'messages'} = $user->getMessages()->CheckForUnreadMsg();
		$info{'todo_size'} = $user->todoList->count();
	}

	return \%info;
}

1;
