#!perl -wW
package CyberArmy::Template::banner;

$CyberArmy::Template::banner::VERSION = '0.1';

use Template::Plugin;
use base qw( Template::Plugin );

use CyberArmy::Banner;
use CyberArmy::WWW::Request;


sub init {
	my $self = shift;
	$self->{'_DYNAMIC'} = 1;
	return $self;
}

sub get {
	my $r = CyberArmy::WWW::Request->instance;
	my $adserver = $r->dir_config('dinah_adserver');
	my $banner = CyberArmy::Banner->new();
	if ($banner->{id}) {
		return {'url' => "$adserver?node=go&amp;id=$banner->{id}", 'image' => "$adserver?node=image&amp;id=$banner->{id}", 'caption' => $banner->{'caption'}};
	} else {
		return 0;
	}
}

1;
