#!/usr/bin/perl -wW
package CyberArmy::Repository;

use strict;
use CyberArmy::Database;

$CyberArmy::Repository::VERSION = '0.2';

sub new {
	my $class = shift;
	my $db = CyberArmy::Database->instance();
	my $self;
	if ($_[0]->{'id'}) {
		$self = $db->selectrow_hashref('
			SELECT * FROM repository_file
			WHERE id = ? LIMIT 1
		',undef,$_[0]->{'id'}) or return undef;
	} elsif ($_[0]->{'path'}) {
		my $file = pop @{$_[0]->{'path'}};
		my $category = CyberArmy::Repository::Category
			->new({path => $_[0]->{'path'}}
		) or return undef;
		$self =	$db->selectrow_hashref('
			SELECT * FROM repository_file 
			WHERE name = ? AND category_id = ?',
			undef,$file,$category->{'id'}
		) or return undef;
	} else {
		my @fields = sort keys %{$_[0]};
		my @values = @{$_[0]}{@fields};

		$db->do(
			'INSERT INTO repository_file ('.join(',',@fields).',upload_date)
				VALUES ('.join(',',(("?")x@values)).',NOW())',undef,@values
		) && return new($class,{id => $db->{'mysql_insertid'}});
	}

	bless ($self,$class);
}

sub remove {
	CyberArmy::Database->instance()->do(
		'DELETE FROM repository_file WHERE id = ?',
	undef,($_[1]->{'id'} || $_[0]->{'id'}));
}

sub update {
	my @fields = sort keys %{$_[1]};
	my @values = @{$_[1]}{@fields};
	CyberArmy::Database->instance->do(
		'UPDATE repository_file SET '
		.join(',',(map{$_.'= ?'}@fields)).
		' WHERE id = ?',undef,@values,
			($_[1]->{'id'} || $_[0]->{'id'})
	);
}

sub getPath {
	my $category = CyberArmy::Repository::Category
		->new({id=>$_[0]->{'category_id'}});
	return $category->{'path'}.'/'.$_[0]->{'name'}
}

package CyberArmy::Repository::Search;

use CyberArmy::Database;
use base qw(CyberArmy::Database::FetchIter);

sub new {
	my $class = shift;
	my $db = CyberArmy::Database->instance();

	my @fields = sort keys %{$_[0]};
	my @values = @{$_[0]}{@fields};
	
	$_[1]->{'logic'} ||= ' AND ';
	$_[1]->{'cmpop'} ||= '=';
	$_[1]->{'where'} ||= '';

	my $select = 'SELECT repository_file.*';
	my $from = 'FROM repository_file';
	
	if ($_[1]->{'join_user'}) {
		$select .=	',users.nickname AS uploaded_by_nickname';
		$from .=	' LEFT JOIN users ON (users.caID = uploaded_by_caid)';
	}
	
	if ($_[1]->{'join_dir'}) {
		$select .=	',path,read_access';
		$from .=	' LEFT JOIN repository_category '.
					'ON (category_id = repository_category.id)';
	}	

	my $self = $db->prepare(join(' ',($select.' '.$from),
		($fields[0] ? 'WHERE ('.join($_[1]->{'logic'},
			map{'repository_file.'.$_.$_[1]->{'cmpop'}.'?'}@fields).')'
			:''),$_[1]->{'where'},
		($_[1]->{'order_by'} ? 'ORDER BY '.$_[1]->{'order_by'} : ''),
		($_[1]->{'limit'} ? 'LIMIT '.$_[1]->{'limit'} : '')

	));

	$self->execute(@values) ? 
		bless ($self,$class) : undef;
}

package CyberArmy::Repository::Category;

sub new {
	my $self;
	my $class = shift;
	my $db = CyberArmy::Database->instance();
	if (defined $_[0]->{'id'}) {
		$self = $db->selectrow_hashref('
			SELECT * FROM repository_category 
			WHERE id = ? LIMIT 1
		',undef,$_[0]->{'id'}) or return undef;
	} elsif ($_[0]->{'path'}) {
		$self =	$db->selectrow_hashref('
			SELECT * FROM repository_category
			WHERE path = ?',undef,
		join('/',@{$_[0]->{'path'}})) or return undef;
	} else {
		my $parent = CyberArmy::Repository::Category
			->new({ id => ($_[0]->{'parent'} ||= 0)});
		my @fields = sort keys %{$_[0]};
		my @values = @{$_[0]}{@fields};
		push (@fields, 'path');
		push (@values, ($parent->{'path'} ?
			$parent->{'path'}.'/'.$_[0]->{'name'} : $_[0]->{'name'}));

		return ($db->do(
			'INSERT INTO repository_category ('.join(',',@fields).')
			VALUES ('.join(',',(("?")x@values)).')',undef,@values))
		? new($class,{id => $db->{'mysql_insertid'}}) : undef;
	}

	bless ($self,$class);
}

sub remove {
	return undef if 
		$_[0]->getListOf()->[0] ||
		CyberArmy::Repository::Search->new({
			category_id => $_[0]->{'id'}
		})->fetch();
	CyberArmy::Database->instance()->do(
		'DELETE FROM repository_category WHERE id = ?',
	undef,$_[0]->{'id'});
}

sub update {
	my @fields = sort keys %{$_[1]};
	my @values = @{$_[1]}{@fields};
	$_ ||= undef foreach (@values);
	CyberArmy::Database->instance->do(
		'UPDATE repository_category SET '
		.join(',', map{$_.'= ?'}@fields).
		' WHERE id = ?',undef,@values,
			($_[1]->{'id'} || $_[0]->{'id'})
	);	
}

sub getListOf {
	my $db = CyberArmy::Database->instance();

	my $getCategories = $db->prepare('
		SELECT * FROM repository_category 
		WHERE parent = ? ORDER BY name,parent
	');

	$getCategories->execute(
		ref$_[0] ? $_[0]->{'id'} : 0);

	return $getCategories->fetchall_arrayref({});
}
