#!perl -wW
package CyberArmy::Remote::Provider::Missions;

use strict;
use XML::RSS;
use LWP::Simple;

use CyberArmy::Utils;
use CyberArmy::WWW::Request;

sub fetch {
	my $remote = $CyberArmy::Utils::Database::dbh->selectrow_hashref
		('SELECT * from remote_mission') or die 'no remote location';
	
	my $missions = get($remote->{'url'}) or die "Can't fetch the missions";
	my $rss = new XML::RSS; eval { $rss->parse($missions) };
	die "Failed parsing the missions rss: $@" if $@;
	
	return 0 if ($rss->{'channel'}->{'updated'} <= $remote->{'last_update'});
	$CyberArmy::Utils::Database::dbh->do('DELETE FROM remote_mission_items');
	
	foreach (@{$rss->{'items'}}) {
		CyberArmy::WWW::Utils::escapeHtml($_->{'title'}, $_->{'category'},
			$_->{'status'}, $_->{'description'},
			$_->{'link'}, $_->{'author'},
			$_->{'date'}); ## nb: the xml parser already doesn't allow bare &, etc
		$CyberArmy::Utils::Database::dbh->do(
			'INSERT INTO remote_mission_items (title,category,status,'.
			'description,link, proposer, dateset) VALUES (?,?,?,?,?,?,?)',undef,$_->{'title'},
			$_->{'category'},$_->{'status'},$_->{'description'},$_->{'link'},
			$_->{'author'},$_->{'date'}
		)
	}

	$CyberArmy::Utils::Database::dbh->do(
		'UPDATE remote_mission SET last_update = ?',
		undef,$rss->{'channel'}->{'updated'}
	);
		

	return 1;
}

1;
