#!perl -wW
package CyberArmy::Remote::Feed;

$CyberArmy::Remote::Feed::VERSION = '0.1';


####
#sub add
#
#Used to create new feed lists.
##
sub add {
	my ($class, $name, $type, $url, $remote) = @_;
	my $db = CyberArmy::Database->instance;
	my $self = $db->do('
		INSERT INTO feed_list (name, type, url, remote)
		VALUES (?, ?, ?, ?)', undef, $name, $type, $url, $remote);
}

####
#sub update
#
#Used to update an existing feed list.
##
sub update {
	my ($class, $id, $name, $type, $url, $remote) = @_;
	my $db = CyberArmy::Database->instance;
	my $self = $db->do('
		UPDATE feed_list SET name =? , type =? , url = ?, remote =?
		WHERE id = ?', undef, $name, $type, $url, $remote, $id);
}

####
#sub delete
#
#Used to delete feed lists. The associated items are NOT deleted at present.
##
sub delete {
	my ($class, $id) = @_;
	my $db = CyberArmy::Database->instance;
	my $self = $db->do('
		DELETE FROM feed_list WHERE id= ?', undef, $id);
}

package CyberArmy::Remote::Feed::List;

use CyberArmy::Database;
use base qw(CyberArmy::Database::FetchIter);

sub new {
	my (undef,$tags) = @_;	
	my $count = $tags->{count};
	my $offset = $tags->{offset};
	my $feedtype = $tags->{feedtype};
	my $where = '';
	if($feedtype)
	{
		$where = " WHERE type = '".$feedtype."'";
	}
	my $limit = "LIMIT 10";
	if($count && $offset)
	{
		$limit = ($count && $offset) ? 'LIMIT '.$offset.','.$count :
			($count ? 'LIMIT '.$count : '');
	}
	my $db = CyberArmy::Database->instance;
	my $self = $db->prepare('
		SELECT name,feed_item.*
		FROM feed_list JOIN feed_item
		ON (feed_item.feed_id = feed_list.id) '.$where.'
		ORDER BY pubdate DESC ' .$limit);

	$self->execute() ? 
		bless ($self,shift) : undef;
}


####
#sub getFeedList
#
#Used to obtain the list of feeds (not the feed items themselves).
##
sub getFeedList {
	my $db = CyberArmy::Database->instance;
	my (@forums,@catlist,$previous);
	my $feeds = $db->prepare('
		SELECT * FROM feed_list ORDER by name ASC');
	$feeds->execute();
	
	my $feedList = $feeds->fetchall_arrayref({});
	return  $feedList;
}


####
#sub getSpecificFeedList
#
#Used to obtain a specific feed list (not the feed items themselves).
##
sub getSpecificFeedList {
	my ($class, $id) = @_;
	my $db = CyberArmy::Database->instance;
	my $feed = $db->selectrow_hashref('
		SELECT * FROM feed_list WHERE id = ?', undef, $id);
	
	return  $feed;
}

sub getAllFeeds {
	my $feeds = CyberArmy::Remote::Feed::List->getFeedList();
	my $db = CyberArmy::Database->instance;
	
	foreach my $feed (@$feeds){		
		my $feeditems = $db->prepare('
			SELECT * FROM feed_item WHERE feed_id=? ORDER BY pubdate DESC');
		$feeditems->execute($feed->{id});
		$feed->{items} = $feeditems->fetchall_arrayref({});
	}
	return $feeds;
}


1;
