#!perl -wW
package CyberArmy::Recruiting;

use strict;
use CyberArmy::User;
use CyberArmy::SkillsDB;
use CyberArmy::Database;

$CyberArmy::Search::VERSION = '0.1';




sub searchSkill {
	my $db = CyberArmy::Database->instance();
	my %tags = @_;
	my (@result,$myquery,@levstat, @winner,@slctskills,@slctlevels,$skillcount);


	foreach my $val ( @{$tags{'skills'}} ) {
		push @slctskills, $val;
	}
    


	#the "basic query"     
	$myquery='SELECT count(user_skill.user_id) = '.scalar(@slctskills).' as matches,user_skill.user_id, '.
		'GROUP_CONCAT(user_skill.skill_id,";",user_skill.level_id) as levels '.
		'FROM user_skill, users '.
		'WHERE user_skill.skill_id IN ('.join(',',map{$db->quote($_)}@slctskills).') '.
		'AND users.caID = user_skill.user_id '.
		'GROUP BY user_skill.user_id';



	#here it appends the ORDER BY stuff to the query
	if ($tags{'orderby'} eq "nickasc"){
		$myquery .= ' ORDER BY users.nickname ASC';
	} elsif ($tags{'orderby'} eq "nickdesc"){
		$myquery .= ' ORDER BY users.nickname DESC';
	} elsif ($tags{'orderby'} eq "brigasc"){
		$myquery .= ' ORDER BY users.brigade ASC';
	} elsif ($tags{'orderby'} eq "brigdesc"){
		$myquery .= ' ORDER BY users.brigade DESC';
	} elsif ($tags{'orderby'} eq "lastseen"){
		$myquery .= ' ORDER BY users.session_ltime DESC';
	} else { return undef }



	my $searchresult = $db->prepare($myquery);
	$searchresult->execute();

		my $skilllevel;
		my $skillid;
		my @skilllevcomb;
		my @stat;

		while (my $stuff = $searchresult->fetchrow_hashref()) {
			if ($stuff->{matches} == 1) {
				@skilllevcomb = split(/,/,$stuff->{levels});
				@skilllevcomb || push @skilllevcomb, $stuff->{levels} ;

					foreach my $pair (@skilllevcomb) {
						($skillid, $skilllevel) = split (/;/,$pair);

						if ($tags{'only'}->{$skillid}) {
							if ($skilllevel == $tags{'levels'}->{$skillid}) {
								push @stat, 1;
							} else {
								push @stat ,"loser";
							}
						} else {
							if ($skilllevel >= $tags{'levels'}->{$skillid}) {
								push @stat, 1;
							} else {
								push @stat ,"loser";
							}
						}
					}

				push @winner, $stuff->{user_id} unless (grep (/loser/,@stat));
				undef (@skilllevcomb);
				undef (@stat);
			}		

		}


	#know I want to know the number of winners
	my $totalresult = scalar(@winner);

	#sort out the offset and limit stuff and adds member details to  @result
	my $counter=0;            
	foreach (@winner) {
		if (($counter >= $tags{'offset'} 
				&& $counter < ($tags{'offset'} + $tags{'limit'})
				) || $tags{limit} eq "all") {
			push @result,CyberArmy::User->new( caID => $_, 
				select => 'pubemail,showname,nickname,brigade_acr,brigade_hex_color'
			);
		}
		$counter++;
	}

	#append the result numbers of the single skills and the search result
	push @result, $totalresult;

	#if there's a result, then return it
	return @result ? \@result : undef;
}             


1;
