#!/usr/bin/perl -W
package CyberArmy::Projects;

use strict;
use CyberArmy::User;
use CyberArmy::Utils;
use CyberArmy::BBCode;
use CyberArmy::Groupware;
use CyberArmy::Database;


$CyberArmy::Projects::VERSION = '0.4_5';

# Public Vars
%CyberArmy::Projects::AccessHash = (
		"I" => "Internal",
		"P" => "Public",
		"C" => "Classified"
);

@CyberArmy::Projects::StatusArray = ("New","Ongoing","Near Completion","Complete");

our $AUTOLOAD;

sub DESTROY {
	## Blah
}

# Phishy
# Same shit as brigades.pm pratically, but obviously adapted for our needs...

sub new {
	my ($class,$project,$sel) = (shift,shift,shift);
	
	return undef unless $project;
	my $key = $project =~ /^\d+$/ ? 'proj_id' : 'proj_group';
	my $selects = $sel ? 'proj_id,proj_group,'.$sel : 'proj_id,proj_group';
	
	if ( my $fields = _GetData($selects,$key,$project) ) {
		my $self = { key => $key, fields => $fields };
		bless($self,$class); return $self;
	} else { return undef }		
}

sub forge {
	my $class = shift;
	my %tags = @_;

	my $self = { key => $tags{key} || 'proj_id', fields => $tags{input} };
	bless($self,$class);
}

## For gettin raw data, used internally
sub _GetData { 
	warn("BQUERY: SELECT $_[0] FROM projects WHERE $_[1] = ? ,$_[2]")
		if $ENV{'DINAH_VERBOSE'};
	$CyberArmy::Utils::Database::dbh->selectrow_hashref(qq~
		SELECT $_[0] FROM projects
		WHERE $_[1] = ?~
	,undef,$_[2]);
}


## Select field(s) and cache them
sub Select {
	my $selects = _GetData($_[1],$_[0]->{key},$_[0]->{fields}->{$_[0]->{key}}) || return undef;
	foreach (keys %{$selects} ) { $_[0]->{fields}->{$_} = $selects->{$_} } return 1;
}

## Get a field value
sub Field { 
	$_[0]->Select($_[1]) unless (exists $_[0]->{fields}->{$_[1]});
	return $_[0]->{fields}->{$_[1]};
}

#</Blagging>

sub GetUsers {
	my ($self) = shift;

	my @users;
	foreach (@{CyberArmy::Groupware->getUsers($self->group)}) {
		push(@users, CyberArmy::User->Forge(key=>'caID',input=>$_));
	}

	return \@users;
}		
	
sub GetLeader {
	my ($self) = shift;
	
	my $leader = CyberArmy::Groupware->getUsers($self->group,3);
	return !$leader->[0] ? undef :
		CyberArmy::User->Forge(key=>'caID',input=>$leader->[0]);
}

sub GetLatest {
	my $args = pop;

	my $select = '*';
	my $limit = 5;
	my $offset;

	if (ref($args) && ref($args) eq 'HASH') {
		$offset = $args->{'offset'} if exists $args->{'offset'};
		$select = $args->{'select'} if exists $args->{'select'};
		$limit = $args->{'limit'} if exists $args->{'limit'} 
					&& $limit =~ /^\d+$/;
	}
	
	$limit = ($limit && $offset) ? 'LIMIT '.$offset.','.$limit :
			($limit ? 'LIMIT '.$limit : '');

	my @news;
	my $n = $CyberArmy::Utils::Database::dbh->prepare("
		SELECT $select FROM project_news 
			LEFT JOIN projects on project_news.proj_id = projects.proj_id 
		WHERE projects.proj_access = 'P' ORDER BY news_id DESC ".$limit);
    $n->execute();
    while(my $row = $n->fetchrow_hashref()) {
        CyberArmy::BBCode::apply($row->{news_content});
        $row->{news_content} =~ s#\n#<BR>#gi if $row->{news_content};
        push(@news,$row);
    }
    return \@news;
}

sub GetAdmin {
	my ($self) = shift;

	## it's the commander of the project's ..
	CyberArmy::Brigades ## .. parent brigade
		->new($self->brigade_parent)->Commander();
}

sub GetNews {
	my $self = shift;
	my @news;
	my $n = $CyberArmy::Utils::Database::dbh->prepare(
		"SELECT * FROM project_news where proj_id = ? ORDER BY news_id DESC LIMIT 5"
	);
	$n->execute($self->id);
	while(my $row = $n->fetchrow_hashref()) {
		CyberArmy::BBCode::apply($row->{news_content});
		$row->{news_content} =~ s#\n#<BR>#gi;
		push(@news,$row);
	}
	return \@news;
}

sub IsClassified {
	return (($_[0]->access eq "C") || ($_[0]->q eq "y")) ? 1 : undef;
}

sub IsQueued {
	return ($_[0]->q eq "y") ? 1 : undef;
}

sub CategoryName {
	my $result = $CyberArmy::Utils::Database::dbh->selectrow_hashref(
		"SELECT * FROM project_categories where category = ?",
		undef,$_[0]->type
	);
	return $result->{category_name};
}

sub AccessName {
	return $CyberArmy::Projects::AccessHash{$_[0]->Field('proj_access')};
}

sub StatusName {
	return $CyberArmy::Projects::StatusArray[$_[0]->Field('proj_status')];
}

sub Log {
	my $self = shift; my %tags = @_;
	
	return undef unless $tags{type};
	$tags{action_by} ||= '[LOG-DAEMON]';

	if ($tags{on} eq 'project') {
		$CyberArmy::Utils::Database::dbh->do(
			'INSERT INTO log_projects (project_id, type, msg, '.
			'action_by, action_by_id, adate) VALUES (?, ?, ?,'.
			'?, ?, NOW())',undef,
		$self->id,$tags{type},$tags{msg},$tags{action_by},
		$tags{action_by_caID}) or return undef;
	} 
	else {
		# Save this for later if we need it...
		return undef;
	}	
}

sub delete {
	my $self = shift;
	my $db = CyberArmy::Database->instance();

	# Clear the users
	$db->do("DELETE FROM user_group where group_id = ?",undef,$self->group);
	# Clear the news
	$db->do("DELETE FROM project_news where proj_id = ?",undef,$self->id);
	# Delete associated ToDos
	$db->do("DELETE FROM user_todo where group_id = ?",undef,$self->group);		
 	# Finally rm the project itself..
	$db->do("DELETE FROM projects where proj_id = ?",undef,$self->id);

	CyberArmy::Groupware->del($self->group);		
}

sub CheckCategory {
	my $self = shift;
	my $db = CyberArmy::Database->instance();
	
	my ($cat) = @_;
	my $ok;
	my $categories = $db->prepare("SELECT * from project_categories");
	$categories->execute();

	while(my $row = $categories->fetchrow_hashref()) {
		$ok = 1 if ($row->{category} eq $cat);
	}
	return ($ok == 1) ? 1 : undef;
}



sub AUTOLOAD {
	$AUTOLOAD =~ s/.*://;
	$_[0]->Field('proj_'.$AUTOLOAD); 
}

sub move {
	my $id = pop;
	my $new_group = pop;
	my $db = CyberArmy::Database->instance();

	## update the group a project is associated with 

	$db->do( 
		'UPDATE projects SET proj_group = ? WHERE proj_id = ?',
	undef,$new_group,$id);

}
1;
