#!/usr/bin/perl -W
package CyberArmy::Mail;

## CyberArmy Interface to Net::SMTP

use strict;
use Net::SMTP;
use CyberArmy;
use CyberArmy::User;
use CyberArmy::Utils;

$CyberArmy::Mail::VERSION = '0.4_7';

sub Send {
	my %tags = @_;
	
	my $to; my $to_name;

	$tags{body} ||= return undef;

	if (ref $tags{to} eq 'ARRAY') { $to = $tags{to}->[0]; $to_name = $tags{to}->[1];} 
	elsif ( $tags{to} ) { $to = $tags{to} }
	elsif ( $tags{user} ) { 
		$to = ${$tags{user}}->prvemail or return undef;
		$to_name = ${$tags{user}}->showname or return undef;
	} elsif (my $key = CyberArmy::Utils::GetKey(\%tags)) {
		$to = CyberArmy::User->new( $key->{name} => $key->{value}, select => 'prvemail')
			->prvemail or return undef
	} else { return undef }
	
	$tags{from} ||= $CyberArmy::Config{'DINAH_ADMIN'};
	$tags{from_name} ||= 'CyberArmy';
	$tags{server} ||= $CyberArmy::Config{'SMTP_RELAY'};

	
	my $smtp = Net::SMTP->new( $tags{server} , Timeout => 5);
	$smtp->mail($tags{from});
	$smtp->recipient($to);
	$smtp->data();
	
	$tags{from_name} ? 
	$smtp->datasend('From: "'.$tags{from_name}.'" <'.$tags{from}.">\n") :
	$smtp->datasend('From: <'.$tags{from}.">\n");
	
	$to_name ? 
	$smtp->datasend('To: "'.$to_name.'" <'.$to.'>'."\n") : 
	$smtp->datasend('To: <'.$to.">\n");
	
	$smtp->datasend('Subject: '.$tags{subject}."\n") if $tags{subject};
	$smtp->datasend(qq~
The following is an automated email from CyberArmy.

$tags{body}

--
CyberArmy,
http://www.cyberarmy.net/about/
			~);
	$smtp->dataend();
	return $smtp->quit;
}
1;
