#!perl -wW
package CyberArmy::Database;

use DBI;
use strict;
use Class::Singleton ();
use base qw(Class::Singleton);

$CyberArmy::Database::VERSION = '0.1';

use CyberArmy;

sub _new_instance {
	return (DBI->connect(
		$CyberArmy::Config{'DINAH_DSN'},'','',
		{ PrintError => 1, RaiseError => 0 } ) 
	or die);
}

package CyberArmy::Database::FetchIter;

use base qw(DBI::st);

sub fetch { goto &DBI::st::fetchrow_hashref }

sub DESTROY { shift->finish }




package CyberArmy::Database::Iterator;

sub new {
	my $class = shift;

	my $self = tie( my(@select), __PACKAGE__, @_ )
		or return undef;
	
	bless ($self, $class);

	return \@select;
}

sub TIEARRAY {
	my $class = shift;
	my $self = shift;

	my $db = CyberArmy::Database->instance;
	$self->{'sth'} = $db->prepare_cached($self->{'sql'});
	if ($self->{'sth'}->execute( @{$self->{'values'}} )) {

		$self->{'row'} ||= ## pre-fetch initialisation
				$self->{'sth'}->fetchrow_hashref()
			or return undef; ## that's one empty query
		## getting here means we have one row at least
		$self->{'size'} = 1; ## so take a note of that

		bless ($self, $class);
	} else { return undef }

}

sub FETCH {
	my ($self,$index) = @_;

	## this class is just iterative, as in only can
	## sequential. While indexes support is easy to
	## acheived by storing up all fetch, that would
	## would defeats the whole point of this module
	return undef unless ($self->{'size'} == ++$index);

	my $row = $self->{'row'}; ## pre-fetched row
	if ($self->{'row'} = $self->{'sth'}->fetchrow_hashref) {
		## notify the iterator only if a new row
		## has sucessfully been pre-fetched, that's
		## to make sure we never go out of bounds
		$self->{'size'}++; ## in respect to @arrays
	}

	return $row;
}

sub FETCHSIZE { $_[0]->{'size'} }

sub DESTROY { $_[0]->{'sth'}->finish }
