#!/usr/bin/perl -W

package CyberArmy::Brigades;

use strict;
use CyberArmy::User;
use CyberArmy::Utils;
use CyberArmy::Database;

$CyberArmy::Brigades::VERSION = '0.4_5';

our $AUTOLOAD;

sub DESTROY {
	## Since we are using AUTOLOAD(), we define a DESTROY sub
	## so AUTOLOAD() won't bother looking for it
}

sub new {
	my ($class,$brigade,$sel) = (shift,shift,shift);

	return undef unless $brigade;
	my $type = $brigade =~ /^\d+$/ ? 'brigade_id' : 'brigade_acr';
	my $selects = $sel ? 'brigade_id,'.$sel : 'brigade_id';

	if ( my $fields = _GetData($selects,$type,$brigade) ) {
		my $self = { key => 'brigade_id', fields => $fields };
		bless($self,$class); return $self;
	} else { return undef }
}

## For gettin raw data, used internally
sub _GetData {
warn("BQUERY: SELECT $_[0] FROM brigades WHERE $_[1] = ? ,$_[2]")
		if $ENV{'DINAH_VERBOSE'};
	$CyberArmy::Utils::Database::dbh->selectrow_hashref(qq~
		SELECT $_[0] FROM brigades
		WHERE $_[1] = ?~
	,undef,$_[2]);
}


## Select field(s) and cache them
sub Select {
	my $selects = _GetData($_[1],$_[0]->{key},$_[0]->{fields}->{$_[0]->{key}}) || return undef;
	foreach (keys %{$selects} ) { $_[0]->{fields}->{$_} = $selects->{$_} } return 1;
}

## Get a field value
sub Field {
	$_[0]->Select($_[1]) unless (exists $_[0]->{fields}->{$_[1]});
	return $_[0]->{fields}->{$_[1]};
}


sub Commander {
	my $selects = $_[1] ? 'caID,'.$_[1] : 'caID';

	return CyberArmy::User->Forge( key => 'caID' ,
		input=> $CyberArmy::Utils::Database::dbh->selectrow_hashref(
				'SELECT '.$selects.' FROM users WHERE brigade = ? AND brigade_pos >= 3',
			undef,$_[0]->id)
	);
}

sub AUTOLOAD {
	$AUTOLOAD =~ s/.*://;
	#eval "sub $AUTOLOAD { \$_[0]->Field('brigade_$AUTOLOAD') }";
	$_[0]->Field('brigade_'.$AUTOLOAD);
}

sub GetProjects {
	# Phishy
	# Returns an array of projects, each with two hashes,
	# 'proj' => CyberArmy::Projects object of the project
	# 'leader' => CyberArmy::User object of the User
	my ($self) = shift;
	my @projects;

	my $getProjects = $CyberArmy::Utils::Database::dbh->prepare(
		'SELECT * from projects where proj_brigade_parent = ? order by proj_name'
	);
	$getProjects->execute($self->id);

	while(my $row = $getProjects->fetchrow_hashref()) {
		my $project = CyberArmy::Projects->new ($row->{"proj_id"});
		push (@projects, { "proj" => $project });
		undef $project;
	}

	return @projects ? \@projects : undef;
}


sub GetUsers {
	my ($self) = shift; my %tags = @_;

	my $selects = $tags{select} ? 'caID,'.$tags{select} : 'caID';
	my $class = $tags{class} ? 'AND brigade_pos = '.$tags{class} : '';
	my $subusers = $tags{subusers} && $tags{subusers} eq 1 ? 1 : undef;

	my $sublist = join(',' , ## what are my subbrigades?
		@{$CyberArmy::Utils::Database::dbh->selectcol_arrayref(
		'SELECT brigade_id FROM brigades '.
		'WHERE brigade_parent = ? ORDER BY brigade_id',
	undef,$self->id)});

	## first step, just get the user ids
	my $getIDs = $CyberArmy::Utils::Database::dbh->selectcol_arrayref(
		'SELECT caID FROM users LEFT JOIN brigades ON brigade = brigade_id '.
		'WHERE (brigade = ? '.($sublist ?
			'OR (brigade IN ('.$sublist.') '. ($subusers ? '))' : 'AND brigade_pos >=3))') :')')
	,undef,$self->id);

	my (@users,$row);

	## now get my user's groups first, based on the user ids
	my $getUserGroups = $CyberArmy::Utils::Database::dbh
	->prepare_cached(
		'SELECT caid,groupware.* FROM user_group '.
		'LEFT JOIN groupware ON group_id = id '.
		'WHERE caid IN ('.join(',',@$getIDs).')'
	);

	my $groups = {};
	$getUserGroups->execute();
	while($row = $getUserGroups->fetchrow_hashref()) {
		$groups->{ $row->{'caid'}}->{$row->{'id'} } = $row if ($row->{'id'});
	} 

	$getUserGroups->finish;

	## now get the actual users, based on the ids bit
	my $getUsers = $CyberArmy::Utils::Database::dbh
	->prepare_cached(
		'SELECT '.$selects.' FROM users '.
		'LEFT JOIN brigades ON brigade = brigade_id '.
		'WHERE caID IN ('.join(',',@$getIDs).')',
	);
	$getUsers->execute();

	while($row = $getUsers->fetchrow_hashref()) {
		$row->{'groups'} = $groups->{$row->{'caID'}};
		push(@users, CyberArmy::User
			->Forge(key => 'caID' , input => $row ))
	}

	$getUsers->finish;

	return \@users;
}

sub getSubBrigades {
	my $sb = $CyberArmy::Utils::Database::dbh->prepare_cached("
		select brigade_id from brigades where brigade_chain REGEXP '".$_[0]->chain."(,?|\$)'
	");
	$sb->execute();
	my $brigades = $sb->fetchall_arrayref();
	$sb->finish;

	return $brigades ? $brigades : undef;
}

sub getJoinQueueCount {

	my $join_cmd = $CyberArmy::Utils::Database::dbh->prepare_cached('
		SELECT COUNT(*) FROM users WHERE brigade = ? AND brigade_pos = 0');
	$join_cmd->execute($_[0]->id);
	my $number = $join_cmd->fetchrow_array();
	$join_cmd->finish; return $number;
}

sub Log {
	my $self = shift; my %tags = @_;

	return undef unless $tags{type};
	$tags{action_by} ||= '[LOG-DAEMON]';

	if ($tags{on} eq 'brigade') {
		$CyberArmy::Utils::Database::dbh->do(
			'INSERT INTO log_brigades (brigade_id, type, msg, '.
			'action_by, action_by_id, adate) VALUES (?, ?, ?,'.
			'?, ?, NOW())',undef,
		$self->id,$tags{type},$tags{msg},$tags{action_by},
		$tags{action_by_caID}) or return undef;
	} elsif ($tags{on} eq 'user') {
		if ($tags{user} && (!$tags{nick} || !$tags{caID})) {
			$tags{nick} = ${$tags{user}}->showname;
			$tags{caID} = ${$tags{user}}->caID;
		} else { return undef }

		$CyberArmy::Utils::Database::dbh->do(
			'INSERT INTO log_brigades_users (brigade_id, action_on,'.
			'action_on_id, type, msg, action_by, action_by_id,'.
			'adate) VALUES (?, ?, ?, ?, ?, ?, ?, NOW())',undef,
		$self->id,$tags{nick},$tags{caID},$tags{type},$tags{msg},
		$tags{action_by},$tags{action_by_caID}) or return undef;

	}
}

sub getLogs {
	my $brigade = shift; my %tags = @_;
	my $db = CyberArmy::Database->instance();
	my $limit = $tags{limit} ? $tags{limit} : 50;
	my $logs;
	my @logs;

	if ($tags{mode} eq "single") { # => only single brigade

		if ($tags{type} eq "users") { # user logs
			$logs = $db->prepare(
				'SELECT * FROM log_brigades_users WHERE brigade_id = ? '.
				'ORDER BY adate DESC LIMIT 0,'.$limit
			);$logs->execute($brigade->id);

		} else { # brig logs
			$logs = $db->prepare(
				'SELECT * FROM log_brigades WHERE brigade_id = ? '.
				'ORDER BY adate DESC LIMIT 0,'.$limit
			);$logs->execute($brigade->id);

		}

		while(my $row = $logs->fetchrow_hashref) {
			my $msg = $row->{msg} ? ' ('.$row->{msg}.')' : '';
			if ($row->{type} eq 'user_join') {
				push @logs,  $row->{adate}.' - '.$row->{action_by}.' accepted '.
					$row->{action_on}.' as a new recruit '."$msg";
			} elsif ($row->{type} eq 'user_kick') {
				push @logs,  $row->{adate}.' - '.$row->{action_by}.
				' kicked '.$row->{action_on}."$msg";
			} elsif ($row->{type} eq 'user_discharge') {
				push @logs, $row->{adate}.' - '.$row->{action_by}.
				' discharged '.$row->{action_on}."$msg";
			} elsif ($row->{type} eq 'user_setco') {
				push @logs, $row->{adate}.' - '.$row->{action_by}.
				' assigns '.$row->{action_on}.' as the commander'."$msg";
			} elsif ($row->{type} eq 'user_unsetco') {
				push @logs, $row->{adate}.' - '.$row->{action_by}.
				' revokes '.$row->{action_on}.'\'s command'."$msg";
			} elsif ($row->{type} eq 'user_setsubco') {
				push @logs, $row->{adate}.' - '.$row->{action_by}.
				' assigns '.$row->{action_on}.' a subcommand'."$msg";
			} elsif ($row->{type} eq 'user_unsetsubco') {
				push @logs, $row->{adate}.' - '.$row->{action_by}.
				' revoked '.$row->{action_on}.'\'s subcommand'."$msg";
			} elsif ($row->{type} eq 'user_setxo') {
				push @logs, $row->{adate}.' - '.$row->{action_by}.
				' gives '.$row->{action_on}.' X/O privileges'."$msg";
			} elsif ($row->{type} eq 'user_unsetxo') {
				push @logs, $row->{adate}.' - '.$row->{action_by}.
				' revokes '.$row->{action_on}.' X/O privileges'."$msg";
			} elsif ($row->{type} eq 'brig_created') {
				push @logs, $row->{adate}.' - Created by '.
				$row->{action_by}."$msg";
			} elsif ($row->{type} eq 'brig_deleted') {
				push @logs, $row->{adate}.' - Deleted by '.
				$row->{action_by}."$msg";
			} elsif ($row->{type} eq 'brig_subdeleted') {
				push @logs, $row->{adate}.' - '.$row->{action_by}.
				' deleted a subbrigade'."$msg";
			} elsif ($row->{type} eq 'brig_subcreated') {
				push @logs, $row->{adate}.' - '.$row->{action_by}.
				' created a subbrigade'."$msg";
			} elsif ($row->{type} eq 'brig_modified') {
				push @logs, $row->{adate}.' - '.$row->{action_by}.
				' modified the brigade\'s settings'."$msg";
			} elsif ($row->{type} eq 'brig_cmodified') {
				push @logs, $row->{adate}.' - '.$row->{action_by}.
				' modified the brigade'."$msg";
			}
		}
	} else { # => + all subs

		my @subbrigades = getSubBrigades($brigade);
		my $title=0;

		foreach (@subbrigades) {
			foreach (@$_) {
				if (!$tags{type}) { # brig logs
					$logs = $db->prepare(
						'SELECT * FROM log_brigades WHERE brigade_id = ? '.
						'ORDER BY adate DESC LIMIT 0,'.$limit
					);$logs->execute(@$_[0]);

				} else { # users logs
					$logs = $db->prepare(
						'SELECT * FROM log_brigades_users WHERE brigade_id = ? '.
						'ORDER BY adate DESC LIMIT 0,'.$limit
					);$logs->execute(@$_[0]);
				}

				while(my $row = $logs->fetchrow_hashref) {
					if ($row->{adate} && !$title) {
						my $brigname = $db->selectrow_array(
							"SELECT brigade_name FROM brigades WHERE brigade_id=?"
						,undef,@$_);

						push @logs, $brigname.'\'s Logs';
						$title=1;
					}

					my $msg = $row->{msg} ? ' ('.$row->{msg}.')' : '';
					if ($row->{type} eq 'user_join') {
						push @logs,
						$row->{adate}.' - '.$row->{action_by}.' accepted '.
							$row->{action_on}.' as a new recruit '."$msg";
					} elsif ($row->{type} eq 'user_kick') {
						push @logs,  $row->{adate}.' - '.$row->{action_by}.
						' kicked '.$row->{action_on}."$msg";
					} elsif ($row->{type} eq 'user_discharge') {
						push @logs, $row->{adate}.' - '.$row->{action_by}.
						' discharged '.$row->{action_on}."$msg";
					} elsif ($row->{type} eq 'user_setco') {
						push @logs, $row->{adate}.' - '.$row->{action_by}.
						' assigns '.$row->{action_on}.' as the commander'."$msg";
					} elsif ($row->{type} eq 'user_unsetco') {
						push @logs, $row->{adate}.' - '.$row->{action_by}.
						' revokes '.$row->{action_on}.'\'s command'."$msg";
					} elsif ($row->{type} eq 'user_setsubco') {
						push @logs, $row->{adate}.' - '.$row->{action_by}.
						' assigns '.$row->{action_on}.' a subcommand'."$msg";
					} elsif ($row->{type} eq 'user_unsetsubco') {
						push @logs, $row->{adate}.' - '.$row->{action_by}.
						' revoked '.$row->{action_on}.'\'s subcommand'."$msg";
					} elsif ($row->{type} eq 'user_setxo') {
						push @logs, $row->{adate}.' - '.$row->{action_by}.
						' gives '.$row->{action_on}.' X/O privileges'."$msg";
					} elsif ($row->{type} eq 'user_unsetxo') {
						push @logs, $row->{adate}.' - '.$row->{action_by}.
						' revokes '.$row->{action_on}.' X/O privileges'."$msg";
					} elsif ($row->{type} eq 'brig_created') {
						push @logs, $row->{adate}.' - Created by '.
						$row->{action_by}."$msg";
					} elsif ($row->{type} eq 'brig_deleted') {
						push @logs, $row->{adate}.' - Deleted by '.
						$row->{action_by}."$msg";
					} elsif ($row->{type} eq 'brig_subdeleted') {
						push @logs, $row->{adate}.' - '.$row->{action_by}.
						' deleted a subbrigade'."$msg";
					} elsif ($row->{type} eq 'brig_subcreated') {
						push @logs, $row->{adate}.' - '.$row->{action_by}.
						' created a subbrigade'."$msg";
					} elsif ($row->{type} eq 'brig_modified') {
						push @logs, $row->{adate}.' - '.$row->{action_by}.
						' modified the brigade\'s settings'."$msg";
					} elsif ($row->{type} eq 'brig_cmodified') {
						push @logs, $row->{adate}.' - '.$row->{action_by}.
						' modified the brigade'."$msg";
					}
				}
				$title=0;
			}
		}
	} #end of if type loop

	return @logs ? \@logs : undef;
}


sub getBrigadeTree {
	my $self = shift;
	my $db = CyberArmy::Database->instance();
	my @tree;
	my %treedetails;

	my $GetBrigades = $db->prepare(
		'SELECT brigade_id,brigade_name,brigade_hex_color,'.
		'brigade_chain,showname,nickname,retired '.
		'FROM brigades LEFT JOIN users ON brigade = brigade_id '.
		'WHERE brigade_pos > 2 '.
		'ORDER BY brigade_chain'
	);
	$GetBrigades->execute();

	my @levels;
	while (my $row = $GetBrigades->fetchrow_hashref) {

		$row->{brigade_name} =~ s/ *^//;
		@levels = split /,/, $row->{brigade_chain};
		my $co = CyberArmy::User->Forge( key => 'nickname' , input => $row );
		my $attributes = $co->getAttributes('title_abrv');
		my $co_name = defined($co) ?
			join(' ',@{$attributes->{'title_abrv'}}) .
				' '.$co->showname : '(unassigned)';

		push @tree, $row->{brigade_id};
		$treedetails{"mybrig"}=$self->id;
		$treedetails{$row->{brigade_id}}{"name"}= $row->{brigade_name};
		$treedetails{$row->{brigade_id}}{"hex_color"}=$row->{brigade_hex_color};
		$treedetails{$row->{brigade_id}}{"level"}=scalar(@levels);
		$treedetails{$row->{brigade_id}}{"co_name"}=$co_name;
		$treedetails{$row->{brigade_id}}{"retired"}=$row->{retired};
	}

return \@tree, \%treedetails;
}


sub getPosCOs {
	my $self = shift;
	my $cbrig = shift;
	my $db = CyberArmy::Database->instance();
	my @COs;


	my $GetCOs = $db->prepare(
		'SELECT caID,nickname,showname,brigade_pos FROM users '.
		'WHERE (brigade = ? OR brigade = ?) AND (brigade_pos > 0 AND brigade_pos < 3)'
	);

	if ($cbrig) { $GetCOs->execute($cbrig,$self->id) }
	else { $GetCOs->execute($self->id,$self->id) }


		while (my $row = $GetCOs->fetchrow_hashref()) {
		push(@COs, CyberArmy::User->new(
			key => 'caID',caID => $row->{caID},
			select => 'nickname,showname' )
		);
	}

	$GetCOs->finish;

	return \@COs;
}


sub update {

	my $self = shift;
	my %attr = @_;
	my $db = CyberArmy::Database->instance();


	if ( $attr{recruiting} ) {	#update brigade settings
		$db->do("UPDATE brigades SET brigade_url=?,brigade_recruiting=?,
				brigade_joinmode=?,brigade_application=?,brigade_invite=?,
				brigade_projac=? WHERE brigade_id = ?",
		undef,$attr{url},$attr{recruiting},$attr{joinmode},
			$attr{application},$attr{invite},$attr{projac},$self->id);

	} elsif ( $attr{name} ) { #update brigade details
		## Update The Brigade Itself
		$db->do("UPDATE brigades ".
				"SET brigade_name=?,brigade_acr=?,brigade_description=? ".
				"WHERE brigade_id = ?",
				undef,$attr{name},$attr{acronym},$attr{description},$self->id
		) or return undef;

		## Update The Colors For The Top Level Brigade
		## And All It's Subs If Needs To
		if ($self->parent == 1) {
			$db->do("UPDATE brigades ".
					"SET brigade_color=?,brigade_hex_color=? ".
					"WHERE brigade_id = ? OR brigade_parent= ?",
					undef,$attr{color},$attr{hex_color},$self->id,$self->id
			) or return undef;
		}
		return 1;
	} else {
		#whatever we'll need it for later
		return undef;
	}

}


sub create {
	my $self = shift;
	my %attrs = @_;
	my $db = CyberArmy::Database->instance();

	$db->do(
		"INSERT INTO brigades (".
		"brigade_parent,brigade_name,brigade_acr,".
		"brigade_description,brigade_color,brigade_hex_color)".
		" VALUES (?,?,?,?,?,?)",undef,
		$attrs{parent_id},$attrs{name},$attrs{acronym},
		$attrs{description},$attrs{color},$attrs{hex_color}
	) or return undef;

	my $nID = $db->{'mysql_insertid'};

	my $chain = $attrs{chain}.','.$nID;
	my $commander = CyberArmy::User->new(nickname => $attrs{commander})
		or return undef;

	if ($commander->Update( setasbrigadeco => $nID)) {
		$CyberArmy::Utils::Database::dbh->do(
			'UPDATE brigades SET brigade_chain=? WHERE brigade_id = ?',
			undef,$chain,$nID
		);
		return $nID;
	} else {
		$db->do("DELETE FROM brigades WHERE brigade_id=?",undef,$nID);
	return undef;
	}


}


sub hasSubs {
	my $db = CyberArmy::Database->instance();
	my $self = shift;

	my $subs = $db->selectrow_arrayref(
		'SELECT brigade_id FROM brigades WHERE brigade_parent = ?',
	undef,$self->id);

 	return $subs->[0] ? 1 : 0;
}


sub hasProjs {
	my $self = shift;
	my $db = CyberArmy::Database->instance();

	my $projs = $db->selectrow_arrayref(
		'SELECT proj_id FROM projects WHERE proj_brigade_parent = ?',
	undef,$self->id);

 	return $projs->[0] ? 1 : 0;
}


sub delete {
		my $self = shift;
		my $db = CyberArmy::Database->instance();
		my $select = 'brigade_id,brigade,brigade_pos,brigade_parent' ;

		foreach (@{$self->GetUsers( select => $select )}) {
				if ($_->brigade_pos >= 3) {
					$_->Update( unsetasbrigadeco => $self->id )
				} else { $_->Update( leavebrigade => 1 ) }
		}

		$db->do(
			'DELETE FROM brigades WHERE brigade_id = ?',
		undef,$self->id);
}


1;
