#!/usr/bin/perl -W
package CyberArmy::Accomplishments;

use strict;
#use CyberArmy::User;
use CyberArmy::Utils;

$CyberArmy::Accomplishments::VERSION = '0.5';

sub getWhoEarnedAccomp {
	my ($class, $acc_id) = @_;

	my $completed = $CyberArmy::Utils::Database::dbh->prepare(
			"SELECT n.caID,n.nickname,n.showname FROM users n 
			JOIN accomplishments_earned v 
			ON n.caID = v.caID 
			WHERE v.status = 1 AND acc_id = ?");

	$completed->execute($acc_id);
	my $completedList = $completed->fetchall_arrayref({});
	return $completedList;
}

sub getCategoryID {
	my ($class, $categname) = @_;
	my $categories = $CyberArmy::Utils::Database::dbh->prepare(
			"SELECT id FROM accomplishments_categories WHERE name = ?");
	$categories->execute($categname);

	my @id = $categories->fetchrow_array();
	return $id[0];
}

sub getAccomplishmentsFromCategory {
	my ($class, $categ) = @_;
	my $accomplishments = $CyberArmy::Utils::Database::dbh->prepare(
			"SELECT id,title,imageurl_before,imageurl_after,
			short_desc,long_desc,can_see_acl,idempotent 
			FROM accomplishments acc 
			WHERE id = (SELECT acc_id FROM accomplishments_link_category WHERE
				acc_id = id AND category_id = ?)");

	$accomplishments->execute($categ);
	my $accomplishmentsList = $accomplishments->fetchall_arrayref({});
	return $accomplishmentsList	
}

sub getAccomplishmentsEarnedByCaid {
	my ($class, $caid) = @_;
	#my $accomplishments = $CyberArmy::Utils::Database::dbh->prepare(
	#		"SELECT acc_id FROM accomplishments_earned WHERE caid = ? AND status = 1");

	my $accomplishments = $CyberArmy::Utils::Database::dbh->prepare(
			"SELECT id,title,imageurl_before,imageurl_after,
			short_desc,long_desc,can_see_acl,idempotent 
			FROM accomplishments acc 
			WHERE (SELECT status FROM accomplishments_earned WHERE caid = ? AND acc_id = acc.id) = 1");
	

	$accomplishments->execute($caid);
	my $accomplishmentsList = $accomplishments->fetchall_arrayref({});
	return $accomplishmentsList;
}

sub getAccomplishmentsEarnedFromCategory {
	my ($class, $caid, $categ) = @_;
	my $accomplishments = $CyberArmy::Utils::Database::dbh->prepare(
			"SELECT id,title,imageurl_before,imageurl_after,
			short_desc,long_desc,can_see_acl,idempotent 
			FROM accomplishments acc 
			WHERE id = (SELECT acc_id FROM accomplishments_link_category acat WHERE
				acat.acc_id = id AND acat.category_id = ? AND (
					SELECT status FROM accomplishments_earned WHERE caid = ? AND acc_id = acat.acc_id) = 1)");

	$accomplishments->execute($categ, $caid);
	my $accomplishmentsList = $accomplishments->fetchall_arrayref({});
	return $accomplishmentsList;
}

sub getCategories {
	my ($class, $caid) = @_;
	my $categoryreq = $CyberArmy::Utils::Database::dbh->prepare(
			"SELECT id,name,displayname,short_desc,can_see_acl,can_award_acl
			FROM accomplishments_categories");

	$categoryreq->execute();
	my $categoryList = $categoryreq->fetchall_arrayref({});
	return $categoryList;	
}

sub getCategoryByName {
	my ($class, $name) = @_;
	my $categoryreq = $CyberArmy::Utils::Database::dbh->prepare(
			"SELECT id,name,displayname,short_desc,can_see_acl,can_award_acl
			FROM accomplishments_categories WHERE name = ?");

	$categoryreq->execute($name);
	my $categoryList = $categoryreq->fetchall_arrayref({});
	return $categoryList;	
}

sub createCategory {
	my ($class, %newCategory) = @_;
	return 0 if !$newCategory{'name'};

	my $categoryreq = $CyberArmy::Utils::Database::dbh->prepare(
			"INSERT INTO accomplishments_categories VALUES 
			(DEFAULT,?,?,?,?,?)");

	$categoryreq->execute(
		$newCategory{'name'},
		$newCategory{'displayname'},
		# colour?
		$newCategory{'short_desc'},
		$newCategory{'can_see_acl'},
		$newCategory{'can_award_acl'}
	);

	return 1;	
}

sub updateCategoryByName {
	my ($class, $categ, %newCategory) = @_;
	return 0 if !$newCategory{'name'};

	my $categoryreq = $CyberArmy::Utils::Database::dbh->prepare(
			"UPDATE accomplishments_categories 
			SET name = ?, displayname = ?, short_desc = ?, can_see_acl = ?, can_award_acl = ?
			WHERE name = ?");

	$categoryreq->execute(
		$newCategory{'name'},
		$newCategory{'displayname'},
		# colour?
		$newCategory{'short_desc'},
		$newCategory{'can_see_acl'},
		$newCategory{'can_award_acl'},
		$categ
	);

	return 1;	
}

sub getAccomplishmentsNotEarnedFromCategory {
	my ($class, $caid, $categ) = @_;
	my $accomplishments = $CyberArmy::Utils::Database::dbh->prepare(
			"SELECT id,title,imageurl_before,imageurl_after,
			short_desc,long_desc,can_see_acl,can_award_acl,idempotent 
			FROM accomplishments acc 
			WHERE id = (SELECT acc_id FROM accomplishments_link_category acat WHERE
				acat.acc_id = id AND acat.category_id = ? AND (
					SELECT status FROM accomplishments_earned WHERE caid = ? AND acc_id = acat.acc_id) IS NULL)");

	$accomplishments->execute($categ, $caid);
	my $accomplishmentsList = $accomplishments->fetchall_arrayref({});
	return $accomplishmentsList;	
}

sub getAccomplishmentDetails {
	my ($class, $id) = @_;
	my $accomplishment_query = $CyberArmy::Utils::Database::dbh->prepare(
			"SELECT id,title,imageurl_before,imageurl_after,
			short_desc,long_desc,can_see_acl,can_award_acl,idempotent 
			FROM accomplishments acc 
			WHERE id = ?");

	$accomplishment_query->execute($id);
	my $accomplishment = $accomplishment_query->fetchall_arrayref({});
	return($accomplishment);
}

sub getAccomplishmentIdByTitle {
	my ($class, $title) = @_;
	my $accomplishment_query = $CyberArmy::Utils::Database::dbh->prepare(
			"SELECT id FROM accomplishments acc WHERE title = ?");

	$accomplishment_query->execute($title);
	my $accomplishment = $accomplishment_query->fetchall_arrayref({});
	return($accomplishment->[0]->{id});
}

sub createAccomplishment {
	my ($class, %newAcc) = @_;
	return 0 if $newAcc{'title'} !~ /\D/;
	my $accomplishment_query = $CyberArmy::Utils::Database::dbh->prepare(
			"INSERT INTO accomplishments VALUES (DEFAULT, 
			?, ?, ?,
			?, ?, ?, ?, ?)");

	# order here is important, see spec
	$accomplishment_query->execute(
		$newAcc{'title'},
		$newAcc{'imageurl_before'},
		$newAcc{'imageurl_after'},
		$newAcc{'short_desc'},
		$newAcc{'long_desc'},
		$newAcc{'can_see_acl'},
		$newAcc{'can_award_acl'},
		$newAcc{'idempotent'}
	);

	return 1;
}

sub deleteAccomplishmentCategories {
	my ($class, $acc_id) = @_;
	return 0 if !$acc_id;

	my $accomplishment_query = $CyberArmy::Utils::Database::dbh->prepare(
			"DELETE FROM accomplishments_link_category WHERE acc_id = ?");

	$accomplishment_query->execute($acc_id);

	return 1;
}

sub linkAccomplishmentToCategory {
	my ($class, $acc_id, $cat_id) = @_;
	my $accomplishment_query = $CyberArmy::Utils::Database::dbh->prepare(
			"INSERT INTO accomplishments_link_category VALUES (?, ?)");

	$accomplishment_query->execute(
		$acc_id,
		$cat_id
	);

	return 1;
}

sub setAccomplishmentDetails {
	my ($class, $id, %newAcc) = @_;
	return 0 if $newAcc{'title'} !~ /\D/;
	my $accomplishment_query = $CyberArmy::Utils::Database::dbh->prepare(
			"UPDATE accomplishments SET 
			title = ?, imageurl_before = ?, imageurl_after = ?,
			short_desc = ?, can_see_acl = ?, long_desc = ?, can_award_acl = ?, idempotent = ? 
			WHERE id = ?");

	$accomplishment_query->execute(
		$newAcc{'title'},
		$newAcc{'imageurl_before'},
		$newAcc{'imageurl_after'},
		$newAcc{'short_desc'},
		$newAcc{'can_see_acl'},
		$newAcc{'long_desc'},
		$newAcc{'can_award_acl'},
		$newAcc{'idempotent'},
		$id
	);

	return 1;
}

sub removeAwardByTitle {
	my ($class, $caid, $accomplishment) = @_;
		my $query_rm = $CyberArmy::Utils::Database::dbh->prepare(
		"DELETE FROM accomplishments_earned 
		WHERE caid = ? 
		AND acc_id = (SELECT id FROM accomplishments WHERE title = ?)"
	);
	$query_rm->execute($caid, $accomplishment);

	return 1;
}

sub awardOnceByTitle {
	my ($class, $caid, $accomplishment, $note, $awarded_by) = @_;
	# Already exists?
	my $query_get_earned_id = $CyberArmy::Utils::Database::dbh->prepare(
		"SELECT id FROM accomplishments_earned WHERE caid = ? AND acc_id = (SELECT id FROM accomplishments WHERE title = ?)");

	$query_get_earned_id->execute($caid, $accomplishment);
	my @idrow = $query_get_earned_id->fetchrow_array();

	return 0 if $idrow[0]; # skip if exists

	# Update accomplishment
	my $query = $CyberArmy::Utils::Database::dbh->prepare(
		"INSERT INTO accomplishments_earned VALUES (DEFAULT, ?, (SELECT id FROM accomplishments WHERE title = ?), 0, 1)");
	$query->execute($caid, $accomplishment);

	# Get the inserted id
	$query_get_earned_id->execute($caid, $accomplishment);
	@idrow = $query_get_earned_id->fetchrow_array();

	# Update note
	die("ERROR INSERTING ACCOMP NOTE, COULD NOT FIND ACCOMP_EARNED ID FROM TABLE FOR TITLE = $accomplishment") if !$idrow[0];  

	my $query_noted = $CyberArmy::Utils::Database::dbh->prepare(
		 "INSERT INTO accomplishments_noted VALUES (DEFAULT, ?, ?, NOW(), ?)");
	$query_noted->execute($idrow[0], $awarded_by, $note);

	return 1;
}

sub awardByTitle {
	my ($class, $caid, $accomplishment, $note, $awarded_by) = @_;
	# Already exists?
	my $query_get_earned_id = $CyberArmy::Utils::Database::dbh->prepare(
		"SELECT id FROM accomplishments_earned WHERE caid = ? AND acc_id = (SELECT id FROM accomplishments WHERE title = ?)");

	$query_get_earned_id->execute($caid, $accomplishment);
	my @idrow = $query_get_earned_id->fetchrow_array();

	if (!$idrow[0]) {
		# Update accomplishment
		my $query = $CyberArmy::Utils::Database::dbh->prepare(
			"INSERT INTO accomplishments_earned VALUES (DEFAULT, ?, (SELECT id FROM accomplishments WHERE title = ?), 0, 1)");
		$query->execute($caid, $accomplishment);

		# Get the inserted id
		$query_get_earned_id->execute($caid, $accomplishment);
		@idrow = $query_get_earned_id->fetchrow_array();
	}

	# Update note
	die("ERROR INSERTING ACCOMP NOTE, COULD NOT FIND ACCOMP_EARNED ID FROM TABLE FOR TITLE = $accomplishment") if !$idrow[0];  

	my $query_noted = $CyberArmy::Utils::Database::dbh->prepare(
		 "INSERT INTO accomplishments_noted VALUES (DEFAULT, ?, ?, NOW(), ?)");
	$query_noted->execute($idrow[0], $awarded_by, $note);

	return 1;
}

sub awardOnce {
	my ($class, $caid, $accomplishment, $note, $awarded_by) = @_;
	if ($accomplishment =~ /\D/) {
		$accomplishment = getAccomplishmentIdByTitle($class, $accomplishment);
	}

	my $acc_details = getAccomplishmentDetails($class, $accomplishment);
	return if !$acc_details->[0]->{'id'};
	return if !$accomplishment;

	# Already exists?
	my $query_get_earned_id = $CyberArmy::Utils::Database::dbh->prepare(
		"SELECT id FROM accomplishments_earned WHERE caid = ? AND acc_id = ?");

	$query_get_earned_id->execute($caid, $accomplishment);
	my @idrow = $query_get_earned_id->fetchrow_array();

	return 0 if $idrow[0]; # skip if exists

	# Update accomplishment
	my $query = $CyberArmy::Utils::Database::dbh->prepare(
		"INSERT INTO accomplishments_earned VALUES (DEFAULT, ?, ?, 0, 1)");
	$query->execute($caid, $accomplishment);

	# Get the inserted id
	$query_get_earned_id->execute($caid, $accomplishment);
	@idrow = $query_get_earned_id->fetchrow_array();

	# Update note
	die("ERROR INSERTING ACCOMP NOTE, COULD NOT FIND ACCOMP_EARNED ID FROM TABLE FOR TITLE = $accomplishment") if !$idrow[0];  

	my $query_noted = $CyberArmy::Utils::Database::dbh->prepare(
		 "INSERT INTO accomplishments_noted VALUES (DEFAULT, ?, ?, NOW(), ?)");
	$query_noted->execute($idrow[0], $awarded_by, $note);

	return 1;
}

sub canAward {
	my ($class, $accomplishment, $user) = @_;
	if ($accomplishment =~ /\D/) {
		$accomplishment = getAccomplishmentIdByTitle($class, $accomplishment);
	}

	return 0 if !$accomplishment;

	my $details = getAccomplishmentDetails($class, $accomplishment);

	if ($user->CheckGroupList('staff') || 
		($details->[0]->{'can_award_acl'} && $user->CheckGroupList($details->[0]->{'can_award_acl'}))) { return 1 }
	else { return 0 }
}

sub canSee {
	my ($class, $accomplishment, $user) = @_;
	if ($accomplishment =~ /\D/) {
		$accomplishment = getAccomplishmentIdByTitle($class, $accomplishment);
	}

	return 0 if !$accomplishment;

	my $details = getAccomplishmentDetails($class, $accomplishment);
	#die("GOT: $accomplishment AND " . ($details->[0]->{'can_see_acl'}));

	if (!$details->[0]->{'can_see_acl'} || $user->CheckGroupList('staff') ||
		($user->CheckGroupList($details->[0]->{'can_see_acl'}) || $user->CheckGroupList($details->[0]->{'can_award_acl'}))) { return 1 }
	else { return 0 }
}

sub canSeeWithDetails {
	my ($class, $details, $user) = @_;
	return 0 if !$details;

	if (!$details->{'can_see_acl'} || $user->CheckGroupList('staff') ||
		$user->CheckGroupList($details->{'can_see_acl'}) || $user->CheckGroupList($details->{'can_award_acl'})) { return 1 }
	else { return 0 }
}

sub filterAccomplishments {
	my($class, $accomplishmentList, $user) = @_;
	my($accomp, $filteredList);

	foreach $accomp (@{$accomplishmentList}) {
		if ($accomp->{'id'} && &canSeeWithDetails($class, $accomp, $user)) {
			push(@{$filteredList}, $accomp);
		}
	}

	return $filteredList;
}

1;
