#!/usr/bin/perl

use strict;
use CyberArmy::User;
use CyberArmy::User::PGPKey;
use CyberArmy::Message;
use CyberArmy::Template;


my @keys = CyberArmy::User::PGPKey->GetExpireWithin(604800);
foreach my $key (@keys) {
	my $tt = CyberArmy::Template->instance;
	$tt->process(
		'misc/pgp_expired.tmpl', {
			pgpkey => $key
		}, \my $body) || die($tt->error());
	print CyberArmy::Message->new(
		from => ['System', undef],
		caID => [$key->{caID}],
		subject => 'Your PGP Key',
		body => $body,
	);
	$key->Warn();		# don't warn them again
}
