/*
 * Decompiled with CFR 0.152.
 */
import IRC.Channel;
import IRC.Event;
import IRC.IRCConnection;
import IRC.Mode;
import IRC.User;
import IRC.Util;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class IRCWindow
extends JPanel {
    public static final int USER = 1;
    public static final int STATUS = 2;
    public static final int CHANNEL = 0;
    private String target;
    private int type;
    private String nick_add_str = "";
    private IRCConnection connection;
    private JTextPane outfield;
    private JLabel topic;
    private Channel nicklist = new Channel("");
    private JButton btn_close;
    private JScrollPane pane;
    private JScrollBar bar;
    private DarkerIRC parent;
    private boolean use_emoticons = false;
    private String channel_fontattributes = null;

    public void setParent(DarkerIRC darkerIRC) {
        this.parent = darkerIRC;
    }

    public void initColors() {
        this.outfield.setBackground(this.parent.getColor("channel.background"));
        this.pane.setBackground(this.parent.getColor("background"));
        this.pane.setForeground(this.parent.getColor("foreground"));
        if (this.type == 0) {
            this.nicklist.setBackground(this.parent.getColor("nicklist.background"));
            this.nicklist.setForeground(this.parent.getColor("nicklist.text"));
            this.nicklist.setFont(this.parent.getFont("nicklist.font"));
            this.topic.setForeground(this.parent.getColor("topic.text"));
            this.topic.setBackground(this.parent.getColor("topic.background"));
            this.topic.setFont(this.parent.getFont("topic.font"));
            this.setBackground(this.parent.getColor("topic.background"));
        }
        this.bar.setValue(this.bar.getMaximum());
        this.use_emoticons = this.parent.getBoolean("use-emoticons");
        this.channel_fontattributes = this.parent.getParameter("channel.fontattributes");
    }

    public IRCWindow(DarkerIRC darkerIRC, IRCConnection iRCConnection, String string, int n) {
        this.parent = darkerIRC;
        this.connection = iRCConnection;
        this.type = n;
        this.target = string;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.setLayout(gridBagLayout);
        this.outfield = new JTextPane();
        this.outfield.setDoubleBuffered(true);
        this.outfield.setEditable(false);
        this.outfield.setContentType("text/html");
        this.outfield.addHyperlinkListener(new HyperActiveListener(darkerIRC));
        this.pane = new JScrollPane(this.outfield);
        this.pane.setAutoscrolls(true);
        this.pane.setVerticalScrollBarPolicy(22);
        this.bar = this.pane.getVerticalScrollBar();
        this.bar.setValue(this.bar.getMaximum());
        if (this.type != 0) {
            gridBagConstraints.anchor = 10;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(this.pane, gridBagConstraints);
        } else {
            this.nicklist.setFont(darkerIRC.getFont("nicklist.font"));
            this.nicklist.setMultipleMode(false);
            this.nicklist.setName(string);
            this.nicklist.conn = this.connection;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(this.nicklist, gridBagConstraints);
            this.add(this.nicklist);
            this.topic = new JLabel("(No Topic is Set)");
            gridBagConstraints.anchor = 11;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            this.topic.setAlignmentX(0.5f);
            gridBagLayout.setConstraints(this.topic, gridBagConstraints);
            this.add(this.topic);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.ipady = 40;
            gridBagLayout.setConstraints(this.pane, gridBagConstraints);
        }
        this.add(this.pane);
    }

    public void setConnection(IRCConnection iRCConnection) {
        this.connection = iRCConnection;
    }

    public void nicklistActionPerformed(ActionEvent actionEvent) {
    }

    public void processEvent(Event event) {
        block94: {
            if (event == null) {
                return;
            }
            if (event.type == 8) {
                this.appendSpeech(event.parseNick((String)event.source), (String)event.body);
            } else if (event.type == 3) {
                String[] stringArray = (String[])event.body;
                String string = (String)event.source;
                this.add("*** Joins: " + string + " [" + stringArray[0] + "@" + stringArray[1] + "] has joined " + (String)event.target, "join");
                if (!this.connection.getNick().equals(string)) {
                    this.nicklist.addUser(User.create(string));
                }
            } else if (event.type == 34) {
                this.addStatus(event.parseNick((String)event.source) + " invites you to join " + (String)event.body, "invite");
            } else if (event.type == 29) {
                this.addStatus("Server Message from " + (String)event.source + ": " + (String)event.body, "server");
            } else if (event.type == 5) {
                String string = (String)event.source;
                String[] stringArray = (String[])event.body;
                this.add("*** Quits: " + string + " [" + stringArray[0] + "@" + stringArray[1] + "] has quit (" + stringArray[2] + ")", "quit");
                if (this.nicklist != null) {
                    this.nicklist.removeUser(User.create(string));
                }
            } else if (event.type == 4) {
                if (this.type == 2) {
                    return;
                }
                String[] stringArray = (String[])event.body;
                String string = (String)event.source;
                this.add("*** Parts: " + (String)event.source + " [" + stringArray[0] + "@" + stringArray[1] + "] has left " + (String)event.target + " " + (stringArray[2] != null ? "(" + stringArray[2] + ")" : ""), "part");
                if (this.nicklist != null) {
                    this.nicklist.removeUser(User.create(string));
                }
            } else if (event.type == 7 || event.type == 19) {
                String[] stringArray = (String[])event.body;
                String string = stringArray[0];
                String string2 = (String)event.source;
                String string3 = (String)event.target;
                if (event.type == 7) {
                    this.add("*** " + string + " has been kicked from " + string3 + " by " + string2 + " [" + stringArray[1] + "@" + stringArray[2] + "] (" + stringArray[3] + ")", "kick");
                    if (this.nicklist != null) {
                        this.nicklist.removeUser(User.create(stringArray[0]));
                    }
                } else {
                    this.add("*** You have been kicked from " + string3 + " by " + string2 + " [" + stringArray[1] + "@" + stringArray[2] + "] (" + stringArray[3] + ")", "kick");
                }
            } else if (event.type == 36) {
                String string = (String)event.source;
                String[] stringArray = (String[])event.body;
                this.add("*** Killed: " + stringArray[0] + " has been killed by " + string + "[" + stringArray[1] + "@" + stringArray[2] + "] for (" + stringArray[3] + ")", "quit");
                if (this.nicklist != null) {
                    this.nicklist.removeUser(User.create(stringArray[0]));
                }
            } else if (event.type == 30) {
                this.add("[" + (String)event.source + "] " + (String)event.body, "whois");
            } else if (event.type == 33) {
                this.add("*** " + event.body + ": " + (String)event.source, "error");
            } else if (event.type == 10) {
                String string = (String)event.body;
                if (string.startsWith("\u0001") && string.endsWith("\u0001")) {
                    string = string.substring(1, string.length() - 1);
                    int n = string.indexOf(32);
                    String string4 = "UNKNOWN";
                    if (n > -1) {
                        string4 = string.substring(0, n);
                        string = string.substring(n + 1);
                    } else {
                        string4 = string;
                        string = "";
                    }
                    if (string4.equals("PING")) {
                        try {
                            long l = Util.unixtime();
                            long l2 = Long.valueOf(string);
                            long l3 = l - l2;
                            this.addStatus("PING reply from " + event.parseNick((String)event.source) + ": " + l3 + " seconds", "ctcp");
                        }
                        catch (Exception exception) {
                            this.addStatus("Malformed PING reply from " + event.parseNick((String)event.source) + ": " + string, "warning");
                        }
                    } else {
                        this.addStatus("CTCP " + string4 + " REPLY from " + event.parseNick((String)event.source) + ": " + string, "ctcp");
                    }
                } else {
                    this.addStatus("Notice from " + event.parseNick((String)event.source) + ": " + (String)event.body, "notice");
                }
            } else if (event.type == 0) {
                String string = (String)event.body;
                this.add("*** Mode change on " + (String)event.target + " by " + (String)event.source + ": " + string, "mode");
                int n = string.indexOf(32);
                if (n > -1) {
                    String string5 = string.substring(0, n);
                    String string6 = string.substring(n + 1);
                    Mode[] modeArray = Util.modeParser(string5, string6);
                    block9: for (int i = 0; i < modeArray.length; ++i) {
                        if (modeArray[i] == null) continue;
                        switch (modeArray[i].token) {
                            case 'o': {
                                this.nicklist.setOps(modeArray[i].args, modeArray[i].add);
                                continue block9;
                            }
                            case 'v': {
                                this.nicklist.setVoice(modeArray[i].args, modeArray[i].add);
                                continue block9;
                            }
                            case 'h': {
                                this.nicklist.setHalfOps(modeArray[i].args, modeArray[i].add);
                            }
                        }
                    }
                }
            } else if (event.type == 17) {
                this.add("* " + event.parseNick((String)event.source) + " " + (String)event.body, "action");
            } else if (event.type == 32) {
                this.addStatus("CTCP Version request from " + event.parseNick((String)event.source), "ctcp");
            } else if (event.type == 24) {
                this.addStatus("CTCP Ping request from " + event.parseNick((String)event.source) + ": " + (String)event.body, "ctcp");
            } else if (event.type == 16) {
                this.add("*** Unknown CTCP from " + event.parseNick((String)event.source) + ": " + (String)event.body, "ctcp");
            } else if (event.type == 26) {
                String string;
                if (event.body != null && (string = (String)event.body) != null && !string.equals("")) {
                    this.connection.say(this.target, string);
                    this.appendSpeech(this.connection.getNick(), string);
                }
            } else if (event.type == 25) {
                String string = (String)event.body;
                String[] stringArray = Util.split(string, " ");
                String string7 = stringArray[0];
                if (string7 != null) {
                    String string8 = DarkerIRC.mapCommand(this, string);
                    if (string8 != null) {
                        this.connection.writeLine(string8);
                        return;
                    }
                    try {
                        if (this.is(string7, "part")) {
                            String string9 = stringArray[1];
                            if (string9 != null) {
                                this.connection.writeLine(string);
                            } else {
                                this.connection.writeLine("PART " + this.target);
                            }
                            return;
                        }
                        if (this.is(string7, "t") || this.is(string7, "topic")) {
                            if (stringArray[2] != null) {
                                stringArray[0] = "";
                                this.connection.writeLine("topic " + this.target + " :" + Util.join(" ", stringArray));
                            } else {
                                this.connection.writeLine("topic " + stringArray[1]);
                            }
                            break block94;
                        }
                        if (this.is(string7, "query") || this.is(string7, "q")) {
                            String string10 = stringArray[1];
                            if (this.type == 1) {
                                this.connection.startQuery(this, string10);
                            } else if (string10 != null && !this.is(string10, "")) {
                                this.connection.startQuery(this, string10);
                            }
                            break block94;
                        }
                        if (this.is(string7, "me")) {
                            String string11 = Util.join(1, " ", stringArray);
                            this.connection.writeLine("PRIVMSG " + this.target + " :" + '\u0001' + "ACTION " + string11 + '\u0001');
                            this.add("* " + this.connection.getNick() + " " + string11, "action");
                            break block94;
                        }
                        if (this.is(string7, "clear")) {
                            Document document = this.outfield.getDocument();
                            document.remove(0, document.getLength());
                            break block94;
                        }
                        String string12 = (String)event.body;
                        if (string12 == null || string12.equals("")) break block94;
                        if (this.connection == null || !this.connection.isConnected()) {
                            this.addStatus("You're not connected yet. Click 'connect' first.", "error");
                            break block94;
                        }
                        this.connection.writeLine(string12);
                    }
                    catch (Exception exception) {
                        System.err.println("Oops: " + exception.toString());
                    }
                }
            } else if (event.type == 13) {
                String[] stringArray = (String[])event.body;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null) continue;
                    this.nicklist.addUser(User.create(stringArray[i]));
                }
            } else if (event.type == 31) {
                this.addStatus((String)event.body, "default");
            } else if (event.type == 9) {
                String string = (String)event.body;
                String string13 = (String)event.source;
                String string14 = (String)event.target;
                this.addStatus("Topic for " + string14 + " is: " + string, "topic");
                if (this.topic != null) {
                    this.topic.setText(string);
                    this.topic.setToolTipText(Util.wordWrap(string, 40));
                }
            } else if (event.type == 11) {
                String string = (String)event.source;
                String string15 = event.parseNick(string);
                String[] stringArray = (String[])event.body;
                String string16 = stringArray[0];
                String string17 = stringArray[1];
                String string18 = stringArray[2];
                this.add("*** " + string15 + " [" + string17 + "@" + string18 + "] is now known as " + string16, "nickchange");
                this.changeNick(string15, string16);
            } else if (event.type == 14) {
                String string = (String)event.target;
                this.addStatus("Nick '" + string + "' is in use.", "nickinuse");
                event.dump();
                if (this.connection.getNick() == null) {
                    this.nick_add_str = this.nick_add_str + "_";
                    this.connection.writeLine("nick " + string + this.nick_add_str);
                }
            } else if (event.type == 27) {
                String string = (String)event.body;
                this.addStatus(string + " " + (String)event.source, "warning");
            } else if (event.type != 28 && event.type != 21) {
                this.addStatus("Unknown Event (type=" + event.type + "): body=" + event.body, "warning");
                event.dump();
            }
        }
    }

    public void addStatus(String string, String string2) {
        this.append("-:- " + string, string2, true);
    }

    public void add(String string, String string2) {
        this.append(string, string2, true);
    }

    private void insertHTML(JTextPane jTextPane, String string, int n) {
        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)jTextPane.getEditorKit();
        HTMLDocument hTMLDocument = (HTMLDocument)jTextPane.getDocument();
        if (n == -1) {
            n = hTMLDocument.getLength();
        }
        try {
            hTMLEditorKit.insertHTML(hTMLDocument, n, string, 0, 0, HTML.Tag.FONT);
        }
        catch (Exception exception) {
            System.err.println("Error while inserting HTML: " + exception.toString());
        }
    }

    public void appendSpeech(String string, String string2) {
        this.append(this.addFontTags("&lt;", "message.braces") + this.addFontTags(string, "message.nickname") + this.addFontTags("&gt;", "message.braces") + " " + this.addFontTags(string2, "message.text"), null, true);
    }

    private String addFontTags(String string, String string2) {
        string2 = this.parent.getParameter("event." + string2 + ".color");
        if (string2 == null) {
            string2 = this.parent.getParameter("event.default.color");
        }
        string = "<font " + this.channel_fontattributes + " color='" + string2 + "'>" + Util.filterMircAttributes(Util.filterHTML(string)) + "</font>";
        if (this.use_emoticons) {
            string = this.parent.replaceEmoticons(string);
            this.parent.debug("Replacing emoticons.");
        }
        return string;
    }

    public void append(String string, String string2, boolean bl) {
        if (string2 != null) {
            string = this.addFontTags(string, string2);
        }
        this.insertHTML(this.outfield, string + "<BR>", -1);
        String string3 = this.outfield.getText();
        this.outfield.setCaretPosition(this.outfield.getDocument().getLength());
    }

    public boolean isTarget(Object object) {
        return object != null && this.target != null && ((String)object).equalsIgnoreCase(this.target);
    }

    public boolean contains(String string) {
        if (this.nicklist == null) {
            return false;
        }
        return this.nicklist.getUser(User.create(string)) != null;
    }

    public void changeNick(String string, String string2) {
        this.nicklist.changeName(string, string2);
    }

    public void remove(String string) {
        if (string == null) {
            string = "No Windows for this channel.";
        }
        if (this.type == 0) {
            this.connection.writeLine("PART " + this.target + " :" + string);
        }
    }

    public String getTitle() {
        return this.target;
    }

    private boolean is(String string, String string2) {
        return string != null && string.equalsIgnoreCase(string2);
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        return this.target;
    }
}

