/*
 * Decompiled with CFR 0.152.
 */
package IRC;

import IRC.Mode;
import IRC.User;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.Date;
import java.util.StringTokenizer;

public class Util {
    static final String RFC1459_rules = "'@'< < '_'< '-'< '`'< 0< 1< 2< 3< 4< 5< 6< 7< 8< 9< a,A< b,B< c,C< d,D< e,E< f,F< g,G< h,H< i,I< j,J< k,K< l,L< m,M< n,N< o,O< p,P< q,Q< r,R< s,S< t,T< u,U< v,V< w,W< x,X< y,Y< z,Z< '{','['< '}',']'< '|','\\'< '^','~'";
    public static Collator collator;
    public static final char BOLD = '\u0002';
    public static final char COLOR = '\u0003';
    public static final char BELL = '\u0007';
    public static final char RESET = '\u000f';
    public static final char UNDOCUMENTED_RESET = '\r';
    public static final char ITALIC = '\u0014';
    public static final char REVERSE = '\u0016';
    public static final char UNDERLINE = '\u001f';
    private static String[] colors;

    public static String[] split(String string, String string2) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens() + 1];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    public static String join(int n, String string, String[] stringArray) {
        String string2 = "";
        for (int i = n; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            string2 = string2 + (i != n ? string : "") + stringArray[i];
        }
        return string2;
    }

    public static String join(String string, String[] stringArray) {
        return Util.join(0, string, stringArray);
    }

    public static String normalizeNick(String string) {
        char c = string.charAt(0);
        if (c == '+' || c == '@' || c == '%') {
            return string.substring(1);
        }
        return string;
    }

    public static Mode[] modeParser(String string, String string2) {
        Mode[] modeArray = new Mode[1024];
        String[] stringArray = Util.split(string2, " ");
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        block14: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            boolean bl2 = false;
            switch (c) {
                case '+': {
                    bl = true;
                    bl2 = true;
                    break;
                }
                case '-': {
                    bl = false;
                    bl2 = true;
                }
            }
            if (bl2) continue;
            switch (c) {
                case 'o': {
                    modeArray[n++] = new Mode(bl, c, stringArray[n2++]);
                    continue block14;
                }
                case 'v': {
                    modeArray[n++] = new Mode(bl, c, stringArray[n2++]);
                    continue block14;
                }
                case 'h': {
                    modeArray[n++] = new Mode(bl, c, stringArray[n2++]);
                    continue block14;
                }
                case 'e': {
                    modeArray[n++] = new Mode(bl, c, stringArray[n2++]);
                    continue block14;
                }
                case 'b': {
                    modeArray[n++] = new Mode(bl, c, stringArray[n2++]);
                    continue block14;
                }
                case 'k': {
                    modeArray[n++] = new Mode(bl, c, stringArray[n2++]);
                    continue block14;
                }
                case 'l': {
                    modeArray[n++] = new Mode(bl, c, stringArray[n2++]);
                    continue block14;
                }
                case 'I': {
                    modeArray[n++] = new Mode(bl, c, stringArray[n2++]);
                    continue block14;
                }
                default: {
                    modeArray[n++] = new Mode(bl, c);
                }
            }
        }
        return modeArray;
    }

    public static int hexToDecimal(String string) {
        return new Integer(Integer.parseInt(string, 16));
    }

    public static void initialize() {
        collator = Util.getCollator();
    }

    public static Collator getCollator() {
        RuleBasedCollator ruleBasedCollator;
        try {
            ruleBasedCollator = new RuleBasedCollator(RFC1459_rules);
        }
        catch (ParseException parseException) {
            System.err.println(parseException);
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException);
            return null;
        }
        ruleBasedCollator.setStrength(1);
        return ruleBasedCollator;
    }

    public static int compare(String string, String string2) {
        return collator.compare(string, string2);
    }

    public static User[] sortItemsAlphabetically(User[] userArray) {
        for (int i = 0; i < userArray.length; ++i) {
            for (int j = userArray.length - 1; j > i; --j) {
                if (userArray[i] == null || userArray[j] == null || collator.compare(userArray[i].nameWithModes(), userArray[j].nameWithModes()) <= 0) continue;
                User user = userArray[i];
                userArray[i] = userArray[j];
                userArray[j] = user;
            }
        }
        return userArray;
    }

    public static String filterHTML(String string) {
        string = Util.replaceCharByString(string, '<', "&lt;");
        string = Util.replaceCharByString(string, '>', "&gt;");
        return Util.replaceURLs(string);
    }

    public static String replaceStringByString(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return string;
        }
        int n = 1;
        while (n > -1) {
            n = string.indexOf(string2);
            if (n <= -1) continue;
            string = string.substring(0, n) + string3 + string.substring(n + string2.length());
        }
        return string;
    }

    public static String replaceCharByString(String string, char c, String string2) {
        if (string == null) {
            return null;
        }
        int n = 1;
        while (n > -1) {
            n = string.indexOf(c);
            if (n <= -1) continue;
            string = string.substring(0, n) + string2 + string.substring(n + 1);
        }
        return string.toString();
    }

    public static String replaceURLs(String string) {
        if (string == null) {
            return string;
        }
        int n = 0;
        if (n >= 0) {
            if ((n = string.indexOf("http://", n)) == -1) {
                return string;
            }
            int n2 = string.indexOf(" ", n + 8);
            if (n2 < n) {
                n2 = string.length() - 1;
            }
            String string2 = string.substring(n, n2 + 1);
            string = string.substring(0, n) + "<a href=\"" + string2 + "\">" + string2 + "</a>" + string.substring(n2 + 1);
            n = n2 + 15;
            return string;
        }
        return string;
    }

    public static String old_filterMircAttributes(String string) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        char[] cArray = new char[n];
        for (n = string.length(); n > 0; --n) {
            char c = string.charAt(n3);
            if (bl && Character.isDigit(c) && n2 < 2 || bl && c == ',' && n2 < 3) {
                ++n2;
                if (c == ',') {
                    n2 = 0;
                }
            } else {
                if (bl) {
                    bl = false;
                }
                switch (c) {
                    case '\u0003': {
                        bl = true;
                        n2 = 0;
                        break;
                    }
                    case '\u0002': 
                    case '\u0007': 
                    case '\u000f': 
                    case '\u0014': 
                    case '\u0016': 
                    case '\u001f': {
                        break;
                    }
                    default: {
                        cArray[n4] = c;
                        ++n4;
                    }
                }
            }
            ++n3;
        }
        return String.valueOf(cArray, 0, n4);
    }

    public static String filterMircAttributes(String string) {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string2 = "";
        String string3 = "";
        for (int i = string.length(); i > 0; --i) {
            char c = string.charAt(n2);
            if (bl2 && Character.isDigit(c) && n < 2 || bl2 && c == ',' && n < 3) {
                ++n;
                if (c == ',') {
                    n = 0;
                }
                string3 = string3 + c;
            } else {
                if (bl2) {
                    bl2 = false;
                    int n3 = 0;
                    try {
                        n3 = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n3 < 0 || n3 >= colors.length) {
                        n3 = 0;
                    }
                    string2 = string2 + "<font color=\"" + colors[n3] + "\">";
                }
                switch (c) {
                    case '\u0003': {
                        bl2 = true;
                        string3 = "";
                        n = 0;
                        string2 = string2 + "</font>";
                        break;
                    }
                    case '\u0002': {
                        if (bl3) {
                            string2 = string2 + "</b>";
                            bl3 = false;
                            break;
                        }
                        string2 = string2 + "<b>";
                        bl3 = true;
                        break;
                    }
                    case '\r': 
                    case '\u000f': {
                        if (bl3) {
                            string2 = string2 + "</b>";
                            bl3 = false;
                        }
                        if (bl4) {
                            string2 = string2 + "</u>";
                            bl4 = false;
                        }
                        if (!bl5) break;
                        string2 = string2 + "</i>";
                        bl5 = false;
                        break;
                    }
                    case '\u001f': {
                        if (bl4) {
                            string2 = string2 + "</u>";
                            bl4 = false;
                            break;
                        }
                        string2 = string2 + "<u>";
                        bl4 = true;
                        break;
                    }
                    case '\u0014': {
                        if (bl5) {
                            string2 = string2 + "</i>";
                            bl5 = false;
                            break;
                        }
                        string2 = string2 + "<i>";
                        bl5 = true;
                        break;
                    }
                    case '\u0016': {
                        break;
                    }
                    case '\u0007': {
                        break;
                    }
                    default: {
                        string2 = string2 + c;
                    }
                }
            }
            ++n2;
        }
        return string2;
    }

    public static long unixtime() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String unixtimeToString(String string) {
        Date date = new Date(new Long(string) * 1000L);
        return date.toString();
    }

    static int stringToInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static String wordWrap(String string) {
        return Util.wordWrap(string, 80, "\n", "-");
    }

    public static String wordWrap(String string, int n) {
        return Util.wordWrap(string, n, "\n", "-");
    }

    public static String wordWrap(String string, String string2, String string3, String string4) {
        return Util.wordWrap(string, Util.stringToInt(string2), string3, string4);
    }

    public static String wordWrap(String string, int n, String string2, String string3) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 / ++n * string2.length() + n2);
        n -= string2.length();
        int n3 = -1;
        String string4 = null;
        for (int i = 0; i < n2; i += n) {
            int n4;
            if (i > n2 - n) {
                stringBuffer.append(string.substring(i));
                break;
            }
            string4 = string.substring(i, i + n);
            n3 = string4.indexOf(string2);
            if (n3 != -1) {
                stringBuffer.append(string4.substring(0, n3));
                stringBuffer.append(string2);
                i -= n - n3 - string2.length();
                if (!Character.isWhitespace(string4.charAt(n3 + 1))) continue;
                ++i;
                continue;
            }
            n3 = -1;
            char[] cArray = string4.toCharArray();
            for (n4 = n; n4 > 0; --n4) {
                if (!Character.isWhitespace(cArray[n4 - 1])) continue;
                n3 = n4;
                break;
            }
            if (n3 == -1) {
                for (n4 = n; n4 > 0; --n4) {
                    if (cArray[n4 - 1] != '-') continue;
                    n3 = n4;
                    break;
                }
                if (n3 == -1) {
                    stringBuffer.append(string4);
                    stringBuffer.append(string2);
                    continue;
                }
                if (n3 != n) {
                    ++n3;
                }
                stringBuffer.append(string4.substring(0, n3));
                stringBuffer.append(string2);
                i -= n - n3;
                continue;
            }
            stringBuffer.append(string4.substring(0, n3));
            stringBuffer.append(Util.repeat(" ", n - n3));
            stringBuffer.append(string2);
            i -= n - n3;
        }
        return stringBuffer.toString();
    }

    static String repeat(String string, int n) {
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            string2 = string2 + string;
        }
        return string2;
    }

    static {
        colors = new String[]{"#FFFFFF", "#000000", "#00007B", "#009400", "#FF0000", "#7B0000", "#9C009C", "#FF7B00", "#FFFF00", "#00FF00", "#009494", "#00FFFF", "#0000FF", "#FF00FF", "#7B7B7B", "#D6D6D6"};
    }
}

