/*
 * Decompiled with CFR 0.152.
 */
package IRC;

import IRC.Event;
import IRC.EventHandler;
import IRC.EventResult;
import IRC.Util;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.security.AccessControlException;

public class IRCConnection
extends Thread {
    private String hostname;
    private int port = 6667;
    public boolean debug = false;
    private String initial_nickname;
    private String nickname;
    private String username;
    private String channel;
    private String quitmsg;
    private String info;
    private EventHandler mainclass;
    public String error;
    private String[] allowed_channels;
    private Socket socket;
    private BufferedReader in;
    private PrintWriter out;
    private boolean connected = false;

    public IRCConnection(EventHandler eventHandler) {
        this.mainclass = eventHandler;
    }

    public IRCConnection(EventHandler eventHandler, String string, int n, String string2, String string3, String string4, String string5, String string6) {
        this.mainclass = eventHandler;
        this.hostname = string;
        this.port = n;
        this.initial_nickname = string2;
        this.channel = string3;
        this.info = string5;
        this.username = string4;
        this.quitmsg = string6;
    }

    public void fireEvent(Event event) {
        this.mainclass.handleEvent(event);
    }

    public void startQuery(Object object, String string) {
        this.mainclass.handleEvent(new Event(28, object, string, null));
    }

    public void startQuery(String string) {
        this.mainclass.handleEvent(new Event(28, null, string, null));
    }

    public void run() {
        if (!this.connected && !this.connect()) {
            System.err.println("Initial connected failed. ");
            return;
        }
        this.nick(this.initial_nickname);
        this.user(this.username, this.info);
        String string = "";
        this.debug("Going into read-loop");
        while (string != null) {
            Event event;
            EventResult eventResult;
            string = this.readLine();
            if (string == null || (eventResult = this.mainclass.handleEvent(event = Event.fromString(string))) == EventResult.OK) continue;
            System.err.println("Event Delivery Failed with code " + eventResult.getValue() + ". Event follows.");
            if (event != null) {
                event.dump();
                continue;
            }
            System.err.println("Event was null. Source: " + string);
        }
    }

    public void debug(String string) {
        if (this.debug) {
            System.out.println("DEBUG: " + string);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean connect() {
        int n = -1;
        try {
            this.socket = new Socket(this.hostname, this.port);
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.out = new PrintWriter((Writer)new OutputStreamWriter(this.socket.getOutputStream()), true);
            this.connected = true;
            this.mainclass.handleEvent(new Event(21, null, null, "Connected to " + this.hostname));
            return true;
        }
        catch (Exception exception) {
            n = 35;
            this.error = "Connect to " + this.hostname + ":" + this.port + " failed: ";
            if (exception instanceof AccessControlException) {
                this.error = this.hostname + ":" + this.port;
                n = 37;
            } else {
                this.error = this.error + exception.toString();
            }
            EventResult eventResult = this.mainclass.handleEvent(new Event(n, null, null, this.error));
            return false;
        }
    }

    public boolean disconnect() {
        try {
            this.quit(this.quitmsg);
            this.in.close();
            this.out.close();
            this.socket.close();
            this.connected = false;
            return true;
        }
        catch (Exception exception) {
            this.error = "Disconnect failed: " + exception.toString();
            this.mainclass.handleEvent(new Event(6, null, null, this.error));
            return false;
        }
    }

    public String readLine() {
        try {
            return this.in.readLine();
        }
        catch (Exception exception) {
            this.error = "Read Error: " + exception.toString();
            return null;
        }
    }

    public void writeLine(String string) {
        if (this.out == null) {
            this.mainclass.handleEvent(new Event(6, null, null, "Not Connected - Click 'Connect' first."));
            return;
        }
        try {
            if (string.toLowerCase().startsWith("join ") && !this.isAllowedChannel(string.substring(5))) {
                return;
            }
            this.out.println(string);
        }
        catch (Exception exception) {
            this.error = "Write Error: " + exception.toString();
            this.mainclass.handleEvent(new Event(6, null, null, this.error));
        }
    }

    public void join(String string) {
        if (this.isAllowedChannel(string)) {
            this.writeLine("JOIN " + string);
        }
    }

    public void quit(String string) {
        this.writeLine("QUIT :" + string);
    }

    public void ctcp(String string, String string2, String string3) {
        string = string.toUpperCase();
        this.writeLine("PRIVMSG " + string2 + " :" + '\u0001' + string + " " + string3 + '\u0001');
    }

    public void say(String string, String string2) {
        this.writeLine("PRIVMSG " + string + " :" + string2);
    }

    public void notice(String string, String string2) {
        this.writeLine("NOTICE " + string + " :" + string2);
    }

    public void mode(String string, String string2) {
        this.writeLine("MODE " + string + " " + string2);
    }

    public void whois(String string) {
        this.writeLine("WHOIS " + string);
    }

    public void nick(String string) {
        this.writeLine("NICK " + string);
    }

    public void user(String string, String string2) {
        this.writeLine("USER " + string + " . . :" + string2);
    }

    public void op(String string, String string2) {
        this.writeLine("MODE " + string + " +o " + string2);
    }

    public void ping(String string) {
        this.writeLine("PRIVMSG " + string + " :" + '\u0001' + "PING " + Util.unixtime() + '\u0001');
    }

    public String getNick() {
        return this.nickname;
    }

    public void setNick(String string) {
        this.nickname = string;
    }

    public void setAllowedChannels(String[] stringArray) {
        this.allowed_channels = stringArray;
    }

    public boolean isAllowedChannel(String string) {
        if (this.allowed_channels == null || this.allowed_channels.length == 0) {
            return true;
        }
        for (int i = 0; i < this.allowed_channels.length; ++i) {
            if (this.allowed_channels[i] == null || !this.allowed_channels[i].equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }
}

