/*
 * Decompiled with CFR 0.152.
 */
package IRC;

import IRC.Util;

public class Event {
    public Object body;
    public Object source;
    public Object target;
    public int type;
    public static final int CHANNELMODE = 0;
    public static final int USERMODE = 1;
    public static final int SERVERMODE = 2;
    public static final int JOIN = 3;
    public static final int PART = 4;
    public static final int QUIT = 5;
    public static final int ERROR = 6;
    public static final int KICK = 7;
    public static final int PRIVMSG = 8;
    public static final int TOPIC = 9;
    public static final int NOTICE = 10;
    public static final int NICK = 11;
    public static final int WELCOME = 12;
    public static final int NAMES = 13;
    public static final int NICKINUSE = 14;
    public static final int PING = 15;
    public static final int CTCP_UNKNOWN = 16;
    public static final int CTCP_ACTION = 17;
    public static final int CTCP_NOTICE = 18;
    public static final int CTCP_PING = 24;
    public static final int CTCP_VERSION = 32;
    public static final int KICKED = 19;
    public static final int CLOSING = 20;
    public static final int STATUS = 21;
    public static final int SELF_JOIN = 22;
    public static final int SELF_PART = 23;
    public static final int USER_COMMAND = 25;
    public static final int USER_MESSAGE = 26;
    public static final int USER_QUERY = 28;
    public static final int WALLOPS = 29;
    public static final int NOSUCHTARGET = 27;
    public static final int WHOISINFO = 30;
    public static final int OTHERINFO = 31;
    public static final int CMD_ERROR = 33;
    public static final int INVITE = 34;
    public static final int DISCONNECTED = 35;
    public static final int KILL = 36;
    public static final int SECURITYERROR = 37;
    public boolean is_global = false;

    public Event(int n, Object object, Object object2, Object object3) {
        this.type = n;
        this.source = object;
        this.target = object2;
        this.body = object3;
    }

    public Event(int n, Object object, Object object2, Object object3, boolean bl) {
        this.type = n;
        this.source = object;
        this.target = object2;
        this.body = object3;
        this.is_global = bl;
    }

    public String toString() {
        return this.body.toString();
    }

    public Object getBody() {
        return this.body;
    }

    public static Event fromString(String string) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        if (string.startsWith("PING")) {
            String[] stringArray = Util.split(string, ":");
            return new Event(15, "server", null, stringArray[1].trim());
        }
        if (string.startsWith("NOTICE")) {
            return new Event(10, "server", null, string.substring(7));
        }
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (string.startsWith(":")) {
            int n;
            int n2;
            String string5 = "";
            int n3 = string.indexOf(":", 1);
            if (n3 == -1) {
                n3 = string.length();
            }
            String string6 = string.substring(1, n3);
            if (n3 != string.length()) {
                string5 = string.substring(n3 + 1);
            }
            String[] stringArray = Util.split(string6, " ");
            string2 = stringArray[0];
            string3 = stringArray[1];
            string4 = stringArray[2];
            String string7 = "server";
            String string8 = "";
            String string9 = "";
            try {
                boolean bl = false;
                n2 = string2.indexOf("!");
                n = string2.indexOf("@");
                string7 = string2.substring(0, n2);
                string8 = string2.substring(n2 + 1, n);
                string9 = string2.substring(n + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String[] stringArray2 = new String[stringArray.length + 1];
            n2 = 0;
            for (n = 3; n < stringArray.length; ++n) {
                if (stringArray[n] == null) continue;
                stringArray2[n - 3] = stringArray[n];
                ++n2;
            }
            if (string5 == null || string5.equals("")) {
                string5 = Util.join(" ", stringArray2);
            }
            stringArray2[n2] = string5;
            stringArray2[n2 + 1] = string;
            if (string3.equals("001")) {
                return new Event(12, "server", stringArray[2], string5);
            }
            if (string3.equals("366") || string3.equals("333")) {
                return null;
            }
            if (string3.equals("321")) {
                return new Event(31, null, "global", "Start of channel listing");
            }
            if (string3.equals("322")) {
                return new Event(31, null, "global", "Channel " + stringArray[3] + " has " + stringArray[4] + " users. Topic: " + string5);
            }
            if (string3.equals("323")) {
                return new Event(31, null, "global", "End of channel listing");
            }
            String[] stringArray3 = new String[]{"372", "002", "003", "004", "005", "251", "252", "253", "254", "255", "265", "266", "275", "375", "376", "381", "442"};
            for (int i = 0; i < stringArray3.length; ++i) {
                if (!string3.equals(stringArray3[i])) continue;
                return new Event(21, "server", string4, string5);
            }
            if (string3.equals("301")) {
                return new Event(31, stringArray[3], "global", stringArray[3] + " is away: " + string5);
            }
            if (string3.equals("307") || string3.equals("313")) {
                return new Event(31, stringArray[3], "global", stringArray[3] + ": " + string5);
            }
            if (string3.equals("332")) {
                return new Event(9, "server", stringArray[3], string5);
            }
            if (string3.equals("482")) {
                return new Event(31, stringArray[3], "global", stringArray[3] + ": " + string5);
            }
            if (string3.equals("318")) {
                return new Event(30, stringArray[3], "global", string5);
            }
            if (string3.equals("319")) {
                return new Event(30, stringArray[3], "global", "On Channels: " + string5);
            }
            if (string3.equals("317")) {
                return new Event(30, stringArray[3], "global", "Seconds Idle: " + stringArray[4] + " (Signon at: " + Util.unixtimeToString(stringArray[5]) + ")");
            }
            if (string3.equals("312")) {
                return new Event(30, stringArray[3], "global", "Using server " + stringArray[4] + ": " + string5);
            }
            if (string3.equals("311")) {
                return new Event(30, stringArray[3], "global", "is " + stringArray[4] + "@" + stringArray[5] + " (" + string5 + ")");
            }
            if (string3.equals("421")) {
                return new Event(33, stringArray[3], "global", "Unknown Command");
            }
            if (string3.equals("431")) {
                return new Event(33, stringArray[3], "global", string5);
            }
            if (string3.equals("461")) {
                return new Event(33, stringArray[3], "global", "Not enough parameters");
            }
            if (string3.equals("464")) {
                return new Event(33, "Try Again", "global", "Password Incorrect");
            }
            if (string3.equals("401") || string3.equals("403")) {
                return new Event(27, stringArray[3], "global", string5);
            }
            if (string3.equals("353")) {
                String[] stringArray4 = Util.split(string5, " ");
                return new Event(13, stringArray[1], stringArray[4], stringArray4);
            }
            if (string3.equals("433")) {
                return new Event(14, null, stringArray[3], null, true);
            }
            if (string3.equalsIgnoreCase("PRIVMSG")) {
                if (string5.charAt(0) == '\u0001') {
                    if ((string5 = string5.substring(1, string5.length() - 1)).startsWith("ACTION")) {
                        string5 = string5.substring(7);
                        return new Event(17, string2, string4, string5);
                    }
                    if (string5.startsWith("VERSION")) {
                        return new Event(32, string2, string4, string5, true);
                    }
                    if (string5.startsWith("PING")) {
                        if (string5.length() > 4) {
                            string5 = string5.substring(5);
                        }
                        return new Event(24, string2, string4, string5, true);
                    }
                    return new Event(16, string2, string4, string5, true);
                }
                return new Event(8, string2, string4, stringArray2[0]);
            }
            if (string3.equalsIgnoreCase("INVITE")) {
                return new Event(34, string2, string4, string5, true);
            }
            if (string3.equalsIgnoreCase("NOTICE")) {
                return new Event(10, string2, "global", string5);
            }
            if (string3.equalsIgnoreCase("JOIN")) {
                return new Event(3, string7, stringArray2[0], new String[]{string8, string9});
            }
            if (string3.equalsIgnoreCase("PART")) {
                return new Event(4, string7, stringArray[2], new String[]{string8, string9, string5});
            }
            if (string3.equalsIgnoreCase("MODE")) {
                return new Event(0, string7, string4, string5.trim());
            }
            if (string3.equalsIgnoreCase("TOPIC")) {
                return new Event(9, string7, string4, stringArray2[0]);
            }
            if (string3.equalsIgnoreCase("KICK")) {
                return new Event(7, string7, stringArray[2], new String[]{stringArray[3], string8, string9, string5});
            }
            if (string3.equalsIgnoreCase("NICK")) {
                return new Event(11, string2, "global", new String[]{stringArray2[0], string8, string9});
            }
            if (string3.equalsIgnoreCase("QUIT")) {
                return new Event(5, string7, "global", new String[]{string8, string9, string5});
            }
            if (string3.equalsIgnoreCase("KILL")) {
                return new Event(36, string7, "global", new String[]{stringArray[2], string8, string9, string5});
            }
            if (string3.equalsIgnoreCase("WALLOPS")) {
                return new Event(29, string7, "global", string5);
            }
        }
        if (string.startsWith("ERROR")) {
            return new Event(6, string2, string4, string.substring(6));
        }
        if (string.startsWith(":Closing Link:")) {
            return new Event(20, string2, string4, string.substring(8));
        }
        System.err.println("Unrecognized event (length=" + string.length() + "): " + string);
        return null;
    }

    public String parseNick(String string) {
        int n = string.indexOf(33);
        if (n > -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public void dump() {
        this.out("IRC.Event(type=" + this.type + ")");
        this.out("\tsource: " + (String)this.source);
        this.out("\ttarget: " + (String)this.target);
        try {
            String[] stringArray = (String[])this.body;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                this.out("\tbody[" + i + "]: " + stringArray[i]);
            }
        }
        catch (Exception exception) {
            try {
                this.out("\tbody: " + (String)this.body);
            }
            catch (Exception exception2) {
                this.out("\t(No body)");
            }
        }
    }

    private void out(String string) {
        System.out.println(string);
    }
}

