/*
 * Decompiled with CFR 0.152.
 */
import IRC.Channel;
import IRC.Event;
import IRC.EventHandler;
import IRC.EventResult;
import IRC.IRCConnection;
import IRC.Server;
import IRC.ServerList;
import IRC.Util;
import jalt.MultiLineToolTipUI;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class DarkerIRC
extends JApplet
implements EventHandler {
    private String nickname = "DarkGuest%";
    private String channel = "#DarkerNet";
    private String info = "www.Darker.net - Dare Thee Expose Thy Darker Side?";
    private String buildinfo = "Built on Thu May 13 21:49:24 CEST 2004 by pj on Porphyrion";
    private IRCConnection connection;
    private String version = "v1.1-pre1";
    public static boolean debug = true;
    private ServerList serverlist;
    private int currentserver;
    private String servername;
    private String versionreply;
    private String quitmessage;
    private String username;
    private String thisnick;
    private String realname;
    private boolean simplemode = false;
    private boolean autoconnect = false;
    private int serverport = 6667;
    private IRCWindow[] windows = new IRCWindow[128];
    private MyIcon img_close;
    private int previous_selected = 0;
    private Properties configuration = new Properties();
    private Properties currenttheme = new Properties();
    private int errorCount = 0;
    private boolean we_must_stop = false;
    private JTabbedPane middenpane;
    private JPanel panel_connect;
    private JLabel txt_nick;
    private JTextField input_nickname;
    private JButton button_connect;
    private JButton button_join;
    private Panel panel1;
    private JTextField field_input;
    private Panel boguspanel;
    private Button sendbutton;
    private String[] history_buffer = new String[1024];
    private int historylist_p = 0;
    private int history_p = 0;
    private static HashMap commands = new HashMap();
    private Frame motd_window;
    String[][] emoticons = new String[1024][2];

    public DarkerIRC() {
        try {
            this.createComponents();
            DarkerIRC.fillCommandsMap();
        }
        catch (Exception exception) {
            this.exclusiveError("Program error. Check console for additional information. \n" + exception.toString());
        }
    }

    public void postInit() {
        this.initComponents();
        MultiLineToolTipUI.initialize();
        this.input_nickname.setText(this.nickname);
        this.boguspanel.setBackground(this.getColor("background"));
        this.boguspanel.setForeground(this.getColor("foreground"));
        this.windows[0] = this.createWindow("Status", "server", 2, new IRCConnection(this));
        this.show(true);
        this.selectWindow(0);
        this.initImages();
        if (this.getBoolean("use-emoticons")) {
            this.getEmoticons();
        }
        Util.initialize();
        System.err.println("DarkerIRC Version " + this.version + " initialized.");
        System.err.println("Build Info: " + this.buildinfo);
        if (this.autoconnect) {
            this.connectbuttonClicked(null);
        }
    }

    public boolean getBoolean(String string) {
        String string2 = this.getParameter(string);
        if (string2 != null) {
            if ((string2 = string2.trim()).equalsIgnoreCase("false")) {
                return false;
            }
            return !string2.equalsIgnoreCase("no");
        }
        return false;
    }

    public String getInteger(String string) {
        String string2 = this.getParameter(string);
        try {
            return string2.trim();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getDimension(String string) {
        String string2 = this.getParameter(string);
        try {
            return string2.trim();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ServerList getServerList(String string) {
        String string2 = this.getParameter(string);
        try {
            return ServerList.create(Util.split(string2.trim(), " "));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String[] getList(String string) {
        String string2 = this.getParameter(string);
        try {
            return Util.split(string2.trim(), " ");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isSet(String string) {
        if (super.getParameter(string) != null) {
            return true;
        }
        if (this.configuration.getProperty(string) != null) {
            return true;
        }
        return this.currenttheme.getProperty(string) != null;
    }

    public String getParameter(String string) {
        String string2 = super.getParameter(string);
        if (string2 != null) {
            return string2;
        }
        if (this.configuration == null) {
            System.err.println("Warning: Premature getParameter request. (" + string + ")");
            return null;
        }
        String string3 = this.configuration.getProperty(string);
        if (string3 == null) {
            string3 = this.currenttheme.getProperty(string);
        }
        if (string3 == null) {
            if (!string.equals("configfile") && !string.equals("limit-channels")) {
                System.err.println("Warning: Property '" + string + "' wasn't set.");
            }
            return null;
        }
        return string3;
    }

    public void init() {
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
        try {
            this.configuration = this.getConfiguration(this.getParameter("configfile"));
            this.currenttheme = this.getConfiguration(this.getParameter("theme"));
            if (this.configuration == null) {
                this.exclusiveError("Required parameter 'configfile' wasn't specified in the applet's HTML code.");
                return;
            }
            this.channel = this.getParameter("channel");
            this.nickname = this.getParameter("nickname");
            this.nickname = Util.replaceCharByString(this.nickname, '%', Math.round(1000.0 * Math.random()) + "");
            this.username = this.getParameter("username");
            this.realname = this.getParameter("realname");
            if (this.isSet("server") || this.isSet("port")) {
                this.warning("Your configfile is probably an older version, since the 'server' and 'port' directives have been replaced by the 'serverlist' one.");
            }
            this.serverlist = this.getServerList("servers");
            this.versionreply = this.getParameter("versionreply");
            this.quitmessage = this.getParameter("quitmessage");
            this.simplemode = this.getBoolean("simple");
            String string = this.getParameter("autoconnect");
            if (string != null && (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("y") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("ja") || string.equalsIgnoreCase("jawohl!"))) {
                this.autoconnect = true;
            }
            this.middenpane.addMouseListener(new MouseInputAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    int n = mouseEvent.getX();
                    int n2 = mouseEvent.getY();
                    int n3 = DarkerIRC.this.middenpane.getSelectedIndex();
                    if (n3 < 0) {
                        return;
                    }
                    MyIcon myIcon = (MyIcon)DarkerIRC.this.middenpane.getIconAt(n3);
                    if (myIcon == null) {
                        return;
                    }
                    int[] nArray = myIcon.location();
                    int n4 = nArray[0];
                    int n5 = nArray[1];
                    if (n > n4 && n < n4 + myIcon.getIconWidth() && n2 > n5 && n2 < n5 + myIcon.getIconHeight()) {
                        DarkerIRC.this.removeWindow((IRCWindow)DarkerIRC.this.middenpane.getComponentAt(n3));
                        DarkerIRC.this.selectWindow(1);
                    }
                }
            });
            this.middenpane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    int n = DarkerIRC.this.middenpane.getSelectedIndex();
                    String string = DarkerIRC.this.middenpane.getTitleAt(n);
                    DarkerIRC.this.middenpane.setBackgroundAt(n, DarkerIRC.this.getColor("tab.background.active"));
                    DarkerIRC.this.middenpane.setForegroundAt(n, DarkerIRC.this.getColor("tab.text.active"));
                    DarkerIRC.this.middenpane.setBackgroundAt(DarkerIRC.this.previous_selected, DarkerIRC.this.getColor("tab.background.normal"));
                    DarkerIRC.this.middenpane.setForegroundAt(DarkerIRC.this.previous_selected, DarkerIRC.this.getColor("tab.text.normal"));
                    DarkerIRC.this.previous_selected = n;
                }
            });
            this.postInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.exclusiveError("Program error. Check console for additional information. \n" + exception.toString());
            return;
        }
    }

    public Font getFont(String string) {
        Font font = Font.decode(this.getParameter(string));
        return font;
    }

    public Color getColor(String string) {
        Color color = this.stringToColor(this.getParameter(string));
        if (color == null) {
            return Color.black;
        }
        return color;
    }

    public Color stringToColor(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        try {
            String string2 = string.substring(0, 2);
            String string3 = string.substring(2, 4);
            String string4 = string.substring(4, 6);
            return new Color(Util.hexToDecimal(string2), Util.hexToDecimal(string3), Util.hexToDecimal(string4));
        }
        catch (Exception exception) {
            System.err.println("Failed to parse color '" + string + "' :" + exception.toString());
            return null;
        }
    }

    public void connect() {
        Server server = this.serverlist.nextServer();
        if (server != null) {
            this.status("Connecting to server " + server.getName());
            this.connection = new IRCConnection(this, server.getName(), server.getPort(), this.thisnick, this.channel, this.username, this.realname, this.quitmessage);
            this.connection.setAllowedChannels(this.getList("limit-channels"));
            this.connection.start();
            this.windows[0].setConnection(this.connection);
            this.field_input.requestFocus();
        }
    }

    public void destroy() {
        this.reset();
    }

    public void status(String string) {
        this.windows[0].processEvent(new Event(21, null, null, string));
    }

    public int addWindow(IRCWindow iRCWindow) {
        for (int i = 0; i < this.windows.length; ++i) {
            if (this.windows[i] != null) continue;
            this.windows[i] = iRCWindow;
            return i;
        }
        return 0;
    }

    public IRCWindow getWindowByName(String string) {
        for (int i = 0; i < this.windows.length; ++i) {
            if (this.windows[i] == null || !this.windows[i].isTarget(string)) continue;
            return this.windows[i];
        }
        return null;
    }

    public void removeWindow(IRCWindow iRCWindow) {
        for (int i = 0; i < this.windows.length; ++i) {
            if (this.windows[i] == null || !this.windows[i].equals(iRCWindow)) continue;
            try {
                this.middenpane.remove(this.windows[i]);
                this.windows[i].remove(this.quitmessage);
                this.windows[i] = null;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int selectWindow(int n) {
        try {
            if (this.middenpane.getComponentAt(n) == null) {
                return n;
            }
            this.middenpane.setSelectedIndex(n);
            this.middenpane.setBackgroundAt(n, this.getColor("tab.background.active"));
            this.middenpane.setForegroundAt(n, this.getColor("tab.text.active"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public int getWindowPosition(String string) {
        return this.middenpane.indexOfTab(string);
    }

    public void highlightWindow(int n) {
        this.dumpWindows();
        if (n >= 0 && n < this.middenpane.getTabCount()) {
            this.middenpane.setBackgroundAt(n, this.getColor("tab.background.highlight"));
            this.middenpane.setForegroundAt(n, this.getColor("tab.text.highlight"));
        }
    }

    public IRCWindow[] getWindowsContaining(String string) {
        IRCWindow[] iRCWindowArray = new IRCWindow[100];
        int n = 0;
        for (int i = 0; i < this.windows.length; ++i) {
            if (this.windows[i] == null || !this.windows[i].contains(string)) continue;
            iRCWindowArray[n++] = this.windows[i];
        }
        return iRCWindowArray;
    }

    public IRCWindow createWindow(String string, String string2, int n, IRCConnection iRCConnection) {
        IRCWindow iRCWindow = new IRCWindow(this, this.connection, string2, n);
        iRCWindow.setForeground(this.getColor("foreground"));
        iRCWindow.setBackground(this.getColor("background"));
        iRCWindow.setConnection(iRCConnection);
        if (n == 2) {
            if (!this.simplemode) {
                this.middenpane.addTab(string, iRCWindow);
            }
        } else {
            this.middenpane.addTab(string, this.img_close, iRCWindow);
        }
        iRCWindow.initColors();
        return iRCWindow;
    }

    public IRCWindow getCurrentWindow() {
        if (this.simplemode) {
            return this.windows[0];
        }
        Component component = this.middenpane.getSelectedComponent();
        if (component instanceof IRCWindow) {
            return (IRCWindow)component;
        }
        return null;
    }

    public void createComponents() {
        this.middenpane = new JTabbedPane();
        this.panel_connect = new JPanel();
        this.txt_nick = new JLabel();
        this.input_nickname = new JTextField();
        this.button_connect = new JButton();
        this.button_join = new JButton();
        this.panel1 = new Panel();
        this.field_input = new JTextField();
        this.boguspanel = new Panel();
        this.sendbutton = new Button();
    }

    private void initComponents() {
        UIManager.put("ScrollBar.shadow", this.getColor("channel.scrollbar.shadow"));
        UIManager.put("ScrollBar.background", this.getColor("channel.scrollbar.background"));
        UIManager.put("ScrollBar.foreground", this.getColor("channel.scrollbar.foreground"));
        UIManager.put("ScrollBar.thumb", this.getColor("channel.scrollbar.thumb"));
        UIManager.put("ScrollBar.thumbHighlight", this.getColor("channel.scrollbar.thumbHighlight"));
        UIManager.put("ScrollBar.thumbDarkShadow", this.getColor("channel.scrollbar.thumbDarkShadow"));
        UIManager.put("ScrollBar.thumbLightShadow", this.getColor("channel.scrollbar.thumbLightShadow"));
        UIManager.put("ScrollBar.thumbShadow", this.getColor("channel.scrollbar.thumbShadow"));
        UIManager.put("ScrollBar.track", this.getColor("channel.scrollbar.track"));
        UIManager.put("ScrollBar.highlight", this.getColor("channel.scrollbar.highlight"));
        UIManager.put("ScrollBar.trackHighlight", this.getColor("channel.scrollbar.trackHighlight"));
        UIManager.put("Panel.background", this.getColor("tab.background"));
        UIManager.put("TabbedPane.selected", this.getColor("tab.background.active"));
        UIManager.put("TabbedPane.background", this.getColor("tab.background.normal"));
        UIManager.put("TabbedPane.font", this.getFont("tab.font"));
        UIManager.put("TabbedPane.shadow", this.getFont("tab.shadow"));
        UIManager.put("TabbedPane.darkshadow", this.getFont("tab.darkshadow"));
        UIManager.put("TabbedPane.highlight", this.getFont("tab.highlight"));
        UIManager.put("TabbedPane.lighthighlight", this.getFont("tab.lighthighlight"));
        UIManager.put("TabbedPane.focus", this.getFont("tab.focus"));
        UIManager.put("OptionPane.background", this.getColor("contentpane.background"));
        UIManager.put("ToolTip.background", this.getColor("tooltip.background"));
        UIManager.put("ToolTip.foreground", this.getColor("tooltip.foreground"));
        this.getContentPane().setBackground(this.getColor("contentpane.background"));
        this.middenpane.setForeground(this.getColor("tab.text.normal"));
        this.middenpane.setBackground(this.getColor("tab.background.normal"));
        this.button_connect.setFont(this.getFont("button.font"));
        this.button_join.setFont(this.getFont("button.font"));
        this.sendbutton.setFont(this.getFont("button.font"));
        this.getContentPane().add((Component)this.middenpane, "Center");
        this.panel_connect.setBackground(this.getColor("contentpane.background"));
        this.txt_nick.setText("Nickname");
        this.txt_nick.setForeground(this.getColor("input.text"));
        this.txt_nick.setBackground(this.getColor("input.background"));
        this.panel_connect.add(this.txt_nick);
        this.input_nickname.setForeground(this.getColor("input.text"));
        this.input_nickname.setText("[Your Name]");
        this.input_nickname.setBackground(this.getColor("input.background"));
        this.input_nickname.setMinimumSize(new Dimension(61, 20));
        this.input_nickname.setColumns(14);
        this.panel_connect.add(this.input_nickname);
        this.button_connect.setForeground(this.getColor("button.text"));
        this.button_connect.setText("Connect");
        this.button_connect.setBackground(this.getColor("button.background"));
        this.button_connect.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DarkerIRC.this.connectbuttonClicked(mouseEvent);
            }
        });
        this.panel_connect.add(this.button_connect);
        this.button_join.setForeground(this.getColor("button.text"));
        this.button_join.setEnabled(false);
        this.button_join.setText("Join Channel");
        this.button_join.setBackground(this.getColor("button.background"));
        this.button_join.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DarkerIRC.this.joinbuttonClicked(mouseEvent);
            }
        });
        if (!this.getBoolean("limit-channels")) {
            this.panel_connect.add(this.button_join);
        }
        this.getContentPane().add((Component)this.panel_connect, "North");
        this.panel1.setLayout(new GridBagLayout());
        this.panel1.setFont(new Font("Dialog", 0, 11));
        this.panel1.setName("panel3");
        this.panel1.setBackground(this.getColor("contentpane.background"));
        this.panel1.setForeground(this.getColor("foreground"));
        this.field_input.setPreferredSize(new Dimension(400, 18));
        this.field_input.setBorder(new LineBorder(Color.white));
        this.field_input.setForeground(this.getColor("input.text"));
        this.field_input.setBackground(this.getColor("input.background"));
        this.field_input.setCaretColor(this.getColor("input.caretcolor"));
        this.field_input.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                DarkerIRC.this.inputKeyTyped(keyEvent);
            }

            public void keyPressed(KeyEvent keyEvent) {
                DarkerIRC.this.field_inputKeyPressed(keyEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.panel1.add((Component)this.field_input, gridBagConstraints);
        this.sendbutton.setLabel("Send");
        this.sendbutton.setName("button_send");
        this.sendbutton.setBackground(this.getColor("button.background"));
        this.sendbutton.setForeground(this.getColor("button.text"));
        this.sendbutton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DarkerIRC.this.sendbuttonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        this.panel1.add((Component)this.sendbutton, gridBagConstraints);
        this.getContentPane().add((Component)this.panel1, "South");
    }

    private void sendbuttonMouseClicked(MouseEvent mouseEvent) {
        this.sendIt();
    }

    private void field_inputKeyPressed(KeyEvent keyEvent) {
        String string;
        if (keyEvent.getKeyCode() == 38 && (string = this.history_up()) != null) {
            this.field_input.setText(string);
        }
        if (keyEvent.getKeyCode() == 40 && (string = this.history_down()) != null) {
            this.field_input.setText(string);
        }
    }

    public Channel createNicklist(String string) {
        Channel channel = new Channel(string);
        channel.setFont(new Font("Dialog", 0, 11));
        channel.setMultipleMode(true);
        channel.setName(string);
        channel.setBackground(this.getColor("nicklist.background"));
        channel.setForeground(this.getColor("nicklist.text"));
        return channel;
    }

    private void sendIt() {
        String string = this.field_input.getText();
        this.userInput(string);
        this.field_input.setText(null);
        this.history_add(string);
        this.history_p = this.historylist_p;
    }

    private void inputKeyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n') {
            this.sendIt();
        }
    }

    private void joinbuttonClicked(MouseEvent mouseEvent) {
        if (this.button_join.isEnabled()) {
            this.showChannelList();
        } else {
            this.addStatus("You're not connected yet. Click 'connect' first.", "warning");
        }
    }

    private void connectbuttonClicked(MouseEvent mouseEvent) {
        if (this.button_connect.getLabel().equals("Disconnect")) {
            if (this.connection != null && this.connection.isConnected()) {
                this.input_nickname.setEnabled(true);
                this.connection.disconnect();
                this.reset();
                this.button_join.setEnabled(false);
                this.button_connect.setLabel("Connect");
            }
        } else {
            String string = this.input_nickname.getText();
            if (string == null || string.equals("")) {
                string = this.showNicknameDialog();
                if (string == null) {
                    this.warning("Please enter your nickname!");
                    return;
                }
                this.input_nickname.setText(string);
            }
            this.button_connect.setLabel("Disconnect");
            this.input_nickname.setEnabled(false);
            this.thisnick = string;
            this.realname = this.realname;
            this.connect();
        }
    }

    public EventResult handleEvent(Event event) {
        IRCWindow iRCWindow;
        String string;
        Object object;
        boolean bl = false;
        if (event == null) {
            return new EventResult("NULL Event given!", 2);
        }
        if (event.type == 12) {
            String string2 = (String)event.target;
            this.connection.setNick(string2);
            this.connection.join(this.channel);
            this.button_join.setEnabled(true);
            this.button_connect.setText("Disconnect");
            if (this.getParameter("automodes") != null) {
                this.connection.mode(string2, this.getParameter("automodes"));
            }
            return EventResult.OK;
        }
        if (event.type == 24) {
            object = event.parseNick((String)event.source);
            string = (String)event.body;
            if (string != null && !string.equals("")) {
                this.connection.notice((String)object, "\u0001PING " + string + "\u0001");
            } else {
                this.connection.notice((String)object, "\u0001PING\u0001");
            }
        }
        if (event.type == 32) {
            object = event.parseNick((String)event.source);
            this.connection.notice((String)object, "\u0001VERSION DarkerIRC " + this.version + " - " + this.versionreply + "\u0001");
        }
        if (event.type == 8 || event.type == 10) {
            // empty if block
        }
        if (event.type == 11) {
            object = (String)event.source;
            string = event.parseNick((String)object);
            String[] stringArray = (String[])event.body;
            String string3 = stringArray[0];
            if (string != null && string.equalsIgnoreCase(this.connection.getNick())) {
                this.connection.setNick(string3);
            }
            IRCWindow[] iRCWindowArray = this.getWindowsContaining((String)event.source);
            for (int i = 0; i < iRCWindowArray.length && iRCWindowArray[i] != null; ++i) {
                iRCWindowArray[i].processEvent(event);
                bl = true;
            }
            return EventResult.OK;
        }
        if (event.target != null && event.is_global) {
            this.getCurrentWindow().processEvent(event);
            return EventResult.OK;
        }
        if (event.target != null && ((String)event.target).equals("global")) {
            this.getCurrentWindow().processEvent(event);
            return EventResult.OK;
        }
        if (event.type == 14) {
            // empty if block
        }
        if (event.type == 15) {
            this.connection.writeLine("PONG " + event.body);
            return EventResult.OK;
        }
        if (event.type == 3 && ((String)(object = (String)event.source)).equalsIgnoreCase(this.connection.getNick())) {
            string = (String)event.target;
            this.selectWindow(this.addWindow(this.createWindow(string, string, 0, this.connection)));
        }
        if (event.type == 4 && ((String)(object = (String)event.source)).equalsIgnoreCase(this.connection.getNick()) && (iRCWindow = this.getWindowByName(string = (String)event.target)) != null) {
            this.removeWindow(iRCWindow);
        }
        if (event.type == 21) {
            this.addStatus((String)event.body, "server");
            return EventResult.OK;
        }
        if (event.type == 6) {
            this.addStatus("Error: " + event.toString(), "error");
            this.reset();
            return EventResult.OK;
        }
        if (event.type == 37) {
            this.reset();
            this.exclusiveError("A Security error occurred while connecting to host '" + event.toString() + "'.\n\n" + "This could have happened because of the following reasons:\n" + "\n" + "1) The administrator of this website did not configure this applet properly.\n" + "2) Your Java security settings are above the normal level\n" + "3) You are the administrator, and are trying to connect to a " + "server which it is not allowed to. Did you *sign* the applet?\n" + "\n" + "This error is most easily solved by reading the documentation, and understanding the configuration file.");
            return new EventResult("Security error", 1);
        }
        if (event.type == 35) {
            if (this.errorCount >= 5) {
                this.exclusiveError("There have been too many problems with this server.\nThe error message is:\n\n" + event.toString() + "\nContact an admin with this message, and details such as your ip-address and the time of this occurance.\n");
                return new EventResult("Connect error", 1);
            }
            this.addStatus("Disconnected: " + event.toString() + ". Connecting to next server", "error");
            ++this.errorCount;
            this.reset();
            this.connect();
            return EventResult.OK;
        }
        if (event.type == 5) {
            object = this.getWindowsContaining((String)event.source);
            for (int i = 0; i < ((IRCWindow[])object).length && object[i] != null; ++i) {
                object[i].processEvent(event);
                bl = true;
            }
        }
        if (event.type == 8 || event.type == 17) {
            object = (String)event.target;
            String string4 = event.parseNick((String)event.source);
            this.debug("Message to " + (String)object + " (Mynick=" + this.connection.getNick() + ")");
            if (object != null && ((String)object).equalsIgnoreCase(this.connection.getNick())) {
                int n;
                for (n = 1; n < this.windows.length; ++n) {
                    if (this.windows[n] == null || !this.windows[n].isTarget(string4)) continue;
                    this.windows[n].processEvent(event);
                    bl = true;
                    this.highlightWindow(n);
                    return EventResult.OK;
                }
                if (!bl && (n = this.addWindow(this.createWindow("Priv: " + string4, string4, 1, this.connection))) >= 0) {
                    this.windows[n].processEvent(event);
                    bl = true;
                    this.highlightWindow(n);
                    return EventResult.OK;
                }
            }
        }
        if (event.type == 28) {
            object = (String)event.target;
            if (object == null) {
                IRCWindow iRCWindow2 = (IRCWindow)event.source;
                this.removeWindow(iRCWindow2);
            } else {
                int n = this.getWindowPosition((String)object);
                if (n > -1) {
                    this.selectWindow(n);
                } else {
                    this.selectWindow(this.addWindow(this.createWindow("Priv: " + (String)object, (String)object, 1, this.connection)));
                }
            }
            bl = true;
        }
        if (event.type == 7) {
            object = ((String[])event.body)[0];
            String string5 = (String)event.target;
            if (((String)object).equalsIgnoreCase(this.connection.getNick())) {
                IRCWindow iRCWindow3 = this.getWindowByName(string5);
                this.removeWindow(iRCWindow3);
                event.type = 19;
            }
        }
        for (int i = 1; i < this.windows.length; ++i) {
            if (this.windows[i] == null || !this.windows[i].isTarget(event.target)) continue;
            this.windows[i].processEvent(event);
            this.highlightWindow(i);
            bl = true;
            break;
        }
        if (!bl) {
            this.windows[0].processEvent(event);
        }
        return EventResult.OK;
    }

    public void dumpWindows() {
        int n;
        for (n = 0; n < this.windows.length; ++n) {
            if (this.windows[n] == null) continue;
        }
        for (n = 0; n < this.middenpane.getTabCount(); ++n) {
            IRCWindow iRCWindow = (IRCWindow)this.middenpane.getComponentAt(n);
            if (iRCWindow == null) continue;
        }
    }

    public void debug(String string) {
        if (debug) {
            System.err.println("debug: " + string);
        }
    }

    public void warning(String string) {
        System.err.println("Warning: " + string);
        if (this.windows[0] != null) {
            this.addStatus(string, "warning");
        }
    }

    private void userInput(String string) {
        int n;
        if (this.connection == null || !this.connection.isConnected()) {
            this.warning("You're not connected yet. Click 'connect' first.");
            return;
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
            while (string.startsWith(" ")) {
                string = string.substring(1);
            }
            n = 25;
        } else {
            n = 26;
        }
        IRCWindow iRCWindow = this.getCurrentWindow();
        if (iRCWindow != null) {
            if (iRCWindow.getType() == 2 && n == 26) {
                this.addStatus("This is the status window, you can't talk here. Click one of the channel pages or join a channel.", "warning");
            } else {
                iRCWindow.processEvent(new Event(n, null, null, string));
            }
        }
    }

    private void reset() {
        for (int i = this.windows.length - 1; i > 0; --i) {
            if (this.windows[i] == null) continue;
            this.windows[i].remove(this.quitmessage);
            this.removeWindow(this.windows[i]);
            this.windows[i] = null;
        }
        this.button_connect.setLabel("Connect");
    }

    private void resetLayout() {
        this.removeAll();
    }

    public String history_up() {
        String string = null;
        if (this.history_p - 1 < 0) {
            this.history_p = this.history_buffer.length - 1;
        }
        if (this.history_buffer[this.history_p] != null) {
            string = this.history_buffer[this.history_p];
            --this.history_p;
        }
        return string;
    }

    public String history_down() {
        String string = null;
        if (this.history_p + 1 >= this.history_buffer.length) {
            this.history_p = 0;
        }
        if (this.history_buffer[this.history_p] != null) {
            string = this.history_buffer[this.history_p];
            ++this.history_p;
        }
        return string;
    }

    public void history_add(String string) {
        ++this.history_p;
        if (this.historylist_p + 1 >= this.history_buffer.length) {
            this.historylist_p = 0;
            this.history_p = 0;
        }
        ++this.historylist_p;
        this.history_buffer[this.historylist_p] = string;
    }

    private static void fillCommandsMap() {
        commands.put("quit", "quit :$1-");
        commands.put("q", "query :$1");
        commands.put("msg", "privmsg $1 :$2-");
        commands.put("t", "topic $channel $1-");
        commands.put("topic", "topic $channel $1-");
        commands.put("k", "kick $channel $1 :$2-");
        commands.put("kick", "kick $channel $1 :$2-");
        commands.put("op", "mode $channel +o $1-");
        commands.put("dop", "mode $channel -o $1-");
        commands.put("deop", "mode $channel -o $1-");
        commands.put("voice", "mode $channel +v $1-");
        commands.put("devoice", "mode $channel -v $1-");
        commands.put("dvoice", "mode $channel -v $1-");
        commands.put("join", "join $1 $2");
        commands.put("j", "join $1 $2");
        commands.put("whois", "whois $1-");
        commands.put("kill", "kill $1 :$2-");
        commands.put("ping", "privmsg $1 :\u0001PING $timestamp\u0001");
        commands.put("ctcp", "privmsg $1 :\u0001$2\u0001");
        commands.put("version", "privmsg $1 :\u0001VERSION\u0001");
    }

    public static String mapCommand(IRCWindow iRCWindow, String string) {
        String string2;
        int n;
        int n2;
        String[] stringArray = Util.split(string, " ");
        String string3 = (String)commands.get(stringArray[0]);
        if (string3 == null) {
            return null;
        }
        String[] stringArray2 = new String[]{"$channel", "$timestamp"};
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            n = string3.indexOf(stringArray2[n2]);
            if (n <= -1) continue;
            string2 = "";
            if (stringArray2[n2].equals("$channel")) {
                string2 = iRCWindow.toString();
            }
            if (stringArray2[n2].equals("$timestamp")) {
                string2 = Util.unixtime() + "";
            }
            string3 = string3.substring(0, n) + string2 + string3.substring(n + stringArray2[n2].length());
        }
        for (n2 = 0; n2 < string3.length() - 1; ++n2) {
            if (string3.charAt(n2) != '$') continue;
            n = -1;
            try {
                n = Integer.parseInt(string3.charAt(n2 + 1) + "");
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            string2 = "";
            int n3 = 0;
            if (string3.length() >= n2 + 3 && string3.charAt(n2 + 2) == '-') {
                string2 = Util.join(n, " ", stringArray);
                n3 = 3;
            } else {
                n3 = 2;
                string2 = stringArray[n];
            }
            string3 = string3.substring(0, n2) + string2 + string3.substring(n2 + n3);
        }
        if (string.startsWith("ctcp")) {
            string3 = string3.toUpperCase();
        }
        return string3;
    }

    public int createDialog(String string, String string2) {
        this.motd_window = new Frame();
        this.motd_window.setTitle(string);
        this.motd_window.add(new TextArea(string2));
        this.motd_window.show();
        return 0;
    }

    private Properties getConfiguration(String string) {
        if (string == null) {
            System.err.println("You did not specify 'configfile' in your html file.");
            return null;
        }
        string = this.getCodeBase() + string;
        try {
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            Properties properties = new Properties();
            properties.load(httpURLConnection.getInputStream());
            return properties;
        }
        catch (Exception exception) {
            System.err.println("Couldn't retrieve configuration file '" + string + "': " + exception.toString());
            this.exclusiveError("Configuration file '" + string + "' " + "Couldn't be retrieved: " + exception.toString());
            return null;
        }
    }

    private void initImages() {
        String string = this.getCodeBase() + "close.gif";
        try {
            this.img_close = new MyIcon(new URL(string));
        }
        catch (Exception exception) {
            System.err.println("Image '" + string + "' not found.");
            this.img_close = new MyIcon(this.getClass().getResource("close.gif"));
        }
    }

    public String showNicknameDialog() {
        JTextField jTextField = new JTextField("");
        jTextField.setEditable(true);
        jTextField.setColumns(14);
        JPanel jPanel = new JPanel();
        jPanel.add(jTextField);
        int n = JOptionPane.showOptionDialog(this, jPanel, "Enter your nickname:", 2, 3, null, null, null);
        if (n == 0) {
            String string = jTextField.getText();
            return string;
        }
        return null;
    }

    public void showChannelList() {
        String string;
        String string2 = this.getParameter("channels");
        String[] stringArray = Util.split(string2, " ");
        int n = 1;
        Object[] objectArray = new Object[stringArray.length];
        objectArray[0] = " ";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            objectArray[n++] = stringArray[i];
        }
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setSelectedItem(" ");
        jComboBox.setEditable(true);
        JPanel jPanel = new JPanel();
        jPanel.add(jComboBox);
        int n2 = JOptionPane.showOptionDialog(this, jPanel, "Select Channel", 2, 3, null, null, null);
        if (n2 == 0 && (string = (String)jComboBox.getSelectedItem()) != null && !string.equals("") && !string.equals(" ")) {
            this.connection.join(string);
        }
    }

    public void getEmoticons() {
        this.readEmoticonsFromEnum(this.configuration);
        this.readEmoticonsFromEnum(this.currenttheme);
    }

    private void readEmoticonsFromEnum(Properties properties) {
        int n = 0;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (!string2.toLowerCase().startsWith("emoticons.") || (string = this.getParameter(string2)) == null) continue;
            this.emoticons[n] = Util.split(string.trim(), " ");
            this.emoticons[n][1] = "<img src=\"" + this.getCodeBase() + "/" + this.emoticons[n][1] + "\">";
            ++n;
        }
    }

    public String replaceEmoticons(String string) {
        if (this.emoticons == null) {
            return string;
        }
        for (int i = 0; i < this.emoticons.length; ++i) {
            string = Util.replaceStringByString(string, this.emoticons[i][0], this.emoticons[i][1]);
        }
        return string;
    }

    public void addStatus(String string, String string2) {
        if (!this.simplemode) {
            this.windows[0].addStatus(string, string2);
        }
    }

    public void exclusiveError(String string) {
        this.warning("Exclusive error found.");
        Label label = new Label("An internal error occurred. Contact an administrator with this error message for more information");
        TextArea textArea = new TextArea(string, 20, 80);
        textArea.setBackground(Color.black);
        this.getContentPane().setForeground(Color.white);
        textArea.setEditable(false);
        this.getAppletContext().showStatus("Error: " + string);
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("North", label);
        this.getContentPane().add("Center", textArea);
        this.repaint();
        this.invalidate();
        this.validate();
    }
}

